/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.aliyunmq;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.enums.HaoTianMessageModel;
import com.ohaotian.plugin.mq.proxy.ext.aliyunmq.AliyunMessageListener;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.ohaotian.plugin.mq.proxy.impl.MQUtils;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AliyunMQMessageConsumerRegister
implements MQRegister,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private Properties mergedProps = new Properties();
    private String defaultValue = "defaultValue";
    private Consumer consumer;
    private boolean started;

    @Override
    @DependsOn(value={"apolloConfigVO"})
    public void register(ConsumerRegisterInfo consumerInfo, ApolloConfigVO apolloConfigVO) {
        ProxyMessageType[] messageTypes;
        String subject = consumerInfo.getSubject();
        for (ProxyMessageType messageType : messageTypes = consumerInfo.getMessageTypes()) {
            if (this.supportConcurrently(messageType)) continue;
            throw new UnsupportedOperationException("Unsuppoorted messageType[" + (Object)((Object)messageType) + "] for subject[" + consumerInfo.getSubject() + "]");
        }
        Properties config = new Properties();
        Properties consumerProps = consumerInfo.getProperties();
        config.put("AccessKey", consumerProps.getProperty("mq.accessKey", apolloConfigVO.getAccessKey()));
        config.put("SecretKey", consumerProps.getProperty("mq.secretKey", apolloConfigVO.getSecretKey()));
        String strategy = consumerInfo.getProperties().getProperty("mq.strategy", apolloConfigVO.getStrategy());
        String messageModel = consumerInfo.getMessageModel();
        if (Strategy.isAliyunMQ(strategy)) {
            config.put("MessageModel", "CLUSTERING");
            if (HaoTianMessageModel.BROADCASTING.getModeCN().equals(messageModel)) {
                config.put("MessageModel", "BROADCASTING");
            }
        }
        this.logger.info("***********\u662f\u5426\u4f7f\u7528gid***********");
        if (StringUtils.isEmpty((Object)apolloConfigVO.getSupportGID())) {
            this.logger.info("***********\u4e0d\u4f7f\u7528gid***********");
            config.put("ConsumerId", consumerInfo.getCid());
            config.put("ONSAddr", consumerProps.getProperty("mq.onsAddr", apolloConfigVO.getOnsAddr()));
        } else {
            this.logger.info("***********\u4f7f\u7528gid***********" + apolloConfigVO.getSupportGID());
            config.put("ConsumerId", consumerInfo.getCid());
            config.put("GROUP_ID", consumerInfo.getCid());
            config.put("NAMESRV_ADDR", consumerProps.getProperty("mq.onsAddr", apolloConfigVO.getOnsAddr()));
        }
        this.consumer = ONSFactory.createConsumer((Properties)config);
        this.consumer.subscribe(subject, MQUtils.tags2Line(consumerInfo.getTags()), (MessageListener)new AliyunMessageListener(consumerInfo.getConsumerWrappers()));
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    protected static ProxyMessage getMessage(Message aliyunMessage) {
        ProxyMessage message;
        try {
            message = new ProxyMessage(aliyunMessage.getTopic(), aliyunMessage.getTag(), new String(aliyunMessage.getBody(), "UTF-8"));
            message.setMessageId(aliyunMessage.getMsgID());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("aliyumMessage 2 ProxyMessage Error", e);
        }
        return message;
    }

    @Override
    public boolean support(String strategy) {
        return AliyunMQMessageConsumerRegister.strategySupported(strategy);
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isAliyunMQ(strategy);
    }

    @Override
    public void startup() {
        if (this.started) {
            return;
        }
        this.consumer.start();
        this.started = true;
    }

    @Override
    public void shutdown() {
        if (!this.started) {
            return;
        }
        this.consumer.shutdown();
        this.started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
    }
}

