/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rocketmq;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.config.MQProperties;
import com.ohaotian.plugin.mq.proxy.config.MQServerProperties;
import com.ohaotian.plugin.mq.proxy.constants.ServerMode;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.enums.HaoTianMessageModel;
import com.ohaotian.plugin.mq.proxy.ext.rocketmq.RocketMQMessageListener;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.ohaotian.plugin.mq.proxy.impl.MQUtils;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RocketMQMessageConsumerRegister
implements MQRegister,
ApplicationContextAware {
    private Properties mergedProps = new Properties();
    private boolean started;
    private DefaultMQPushConsumer consumer;
    @Autowired
    private ApplicationContext applicationContext;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void register(ConsumerRegisterInfo consumerInfo, ApolloConfigVO apolloConfigVO, MQProperties mqProperties) {
        ProxyMessageType[] messageTypes;
        String subject = consumerInfo.getSubject();
        for (ProxyMessageType messageType : messageTypes = consumerInfo.getMessageTypes()) {
            if (this.supportConcurrently(messageType)) continue;
            throw new UnsupportedOperationException("Unsuppoorted messageType[" + (Object)((Object)messageType) + "] for subject[" + consumerInfo.getSubject() + "]");
        }
        if (apolloConfigVO != null && ServerMode.isCluster(apolloConfigVO.getServerMode())) {
            Map<String, MQServerProperties> datasource = mqProperties.getDatasource();
            if (datasource == null || datasource.size() <= 0) throw new ProxyMessageException("MQ Server \u672a\u914d\u7f6e\uff0cDataSource = [" + datasource.size() + "] ", null);
            try {
                for (Map.Entry<String, MQServerProperties> entry : datasource.entrySet()) {
                    if (StringUtils.isEmpty((Object)consumerInfo.getServerId()) || !entry.getKey().equalsIgnoreCase(consumerInfo.getServerId())) continue;
                    MQServerProperties mqServerProperties = mqProperties.getDatasource().get(entry.getKey());
                    DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(mqServerProperties.getInstanceName());
                    consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
                    String strategy = mqProperties.getStrategy();
                    String messageModel = consumerInfo.getMessageModel();
                    if (Strategy.isRocketMQ(strategy)) {
                        consumer.setMessageModel(MessageModel.CLUSTERING);
                        if (HaoTianMessageModel.BROADCASTING.getModeCN().equals(messageModel)) {
                            consumer.setMessageModel(MessageModel.BROADCASTING);
                        }
                    }
                    consumer.setNamesrvAddr(mqServerProperties.getServerUrl());
                    consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
                    consumer.subscribe(subject, MQUtils.tags2Line(consumerInfo.getTags()));
                    consumer.setInstanceName(mqServerProperties.getInstanceName());
                    consumer.registerMessageListener((MessageListenerConcurrently)new RocketMQMessageListener(consumerInfo.getConsumerWrappers()));
                    consumer.start();
                    return;
                }
                return;
            }
            catch (Exception e) {
                throw new ProxyMessageException("Register consumer error", e);
            }
        }
        this.consumer = new DefaultMQPushConsumer(consumerInfo.getCid());
        this.consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        String strategy = consumerInfo.getProperties().getProperty("mq.strategy", apolloConfigVO.getStrategy());
        String messageModel = consumerInfo.getMessageModel();
        if (Strategy.isRocketMQ(strategy)) {
            this.consumer.setMessageModel(MessageModel.CLUSTERING);
            if (HaoTianMessageModel.BROADCASTING.getModeCN().equals(messageModel)) {
                this.consumer.setMessageModel(MessageModel.BROADCASTING);
            }
        }
        this.consumer.setNamesrvAddr(consumerInfo.getProperties().getProperty("mq.rocket.namesrvaddr", apolloConfigVO.getRocketNamesrvaddr()));
        try {
            this.consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
            this.consumer.subscribe(subject, MQUtils.tags2Line(consumerInfo.getTags()));
            this.consumer.setInstanceName(UUID.randomUUID().toString());
        }
        catch (MQClientException e) {
            throw new IllegalStateException("Consumer[" + consumerInfo.getSubject() + "] subscribe error", e);
        }
        this.consumer.registerMessageListener((MessageListenerConcurrently)new RocketMQMessageListener(consumerInfo.getConsumerWrappers()));
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    protected static ProxyMessage getMessage(MessageExt messageExt) {
        ProxyMessage message;
        try {
            message = new ProxyMessage(messageExt.getTopic(), messageExt.getTags(), new String(messageExt.getBody(), "UTF-8"));
            message.setMessageId(messageExt.getMsgId());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("MessageExt 2 ProxyMessage Error", e);
        }
        return message;
    }

    @Override
    public boolean support(String strategy) {
        return RocketMQMessageConsumerRegister.strategySupported(strategy);
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isRocketMQ(strategy);
    }

    @Override
    public void startup() {
        if (this.started) {
            return;
        }
        try {
            if (this.consumer != null) {
                this.consumer.start();
            }
        }
        catch (MQClientException e) {
            throw new IllegalStateException("Start MQConsumer error", e);
        }
        this.started = true;
    }

    @Override
    public void shutdown() {
        if (!this.started) {
            return;
        }
        if (this.consumer != null) {
            this.consumer.shutdown();
        }
        this.started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
    }
}

