/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rocketmq;

import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyExceptionContext;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.config.MQProperties;
import com.ohaotian.plugin.mq.proxy.config.MQServerProperties;
import com.ohaotian.plugin.mq.proxy.constants.ServerMode;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.ext.rocketmq.RocketMqTransactionCheckListener;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageException;
import com.ohaotian.plugin.mq.proxy.status.ProxyTransactionStatus;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.LocalTransactionExecuter;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.TransactionCheckListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RocketMqMessageSender
implements ProxyMessageProducerEx,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private DefaultMQProducer producer;
    private TransactionMQProducer transProductor;
    private final String subject;
    private final Map<ProxyMessageType, Set<String>> typeTagsMapping;
    private RocketMqTransactionCheckListener transactionCheckerListener;
    private CacheStore cacheStore;
    private Properties mergedProps = new Properties();
    private ApolloConfigVO apolloConfigVO;
    private Map<String, DefaultMQProducer> producers = new LinkedHashMap<String, DefaultMQProducer>();
    private Map<String, TransactionMQProducer> transProductors = new LinkedHashMap<String, TransactionMQProducer>();
    private MQProperties mqProperties;
    private String defaultValue = "defaultValue";
    private final ProxyMessageConfig messageConfig;
    private final int[] data = new int[]{1, 5, 10, 30, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600, 1200, 1800, 3600, 7200};

    public RocketMqMessageSender(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping, MQProperties mqProperties) {
        this.subject = messageConfig.getSubject();
        this.messageConfig = messageConfig;
        this.typeTagsMapping = typeTagsMapping;
        this.mqProperties = mqProperties;
    }

    private DefaultMQProducer getMQProducerByServerId(String serverId) {
        DefaultMQProducer defaultMQProducer = null;
        if (this.producers != null && this.producers.size() > 0) {
            for (Map.Entry<String, DefaultMQProducer> entry : this.producers.entrySet()) {
                if (StringUtils.isEmpty((Object)serverId) || !entry.getKey().equalsIgnoreCase(serverId)) continue;
                defaultMQProducer = this.producers.get(entry.getKey());
                break;
            }
        }
        return defaultMQProducer;
    }

    private TransactionMQProducer getTransactionMQProducerByServerId(String serverId) {
        TransactionMQProducer transactionMQProducer = null;
        if (this.transProductors != null && this.transProductors.size() > 0) {
            for (Map.Entry<String, TransactionMQProducer> entry : this.transProductors.entrySet()) {
                if (StringUtils.isEmpty((Object)serverId) || !entry.getKey().equalsIgnoreCase(serverId)) continue;
                transactionMQProducer = this.transProductors.get(entry.getKey());
                break;
            }
        }
        return transactionMQProducer;
    }

    @Override
    public ProxySendResult send(ProxyMessage message) {
        ProxySendResult proxySendResult = null;
        try {
            DefaultMQProducer defaultMQProducer = null;
            defaultMQProducer = this.apolloConfigVO != null && ServerMode.isCluster(this.apolloConfigVO.getServerMode()) ? this.getMQProducerByServerId(message.getServerId()) : this.producer;
            if (defaultMQProducer != null) {
                SendResult sendResult = defaultMQProducer.send(this.getMessage(message));
                proxySendResult = this.getProxySendResult(sendResult);
            }
        }
        catch (Exception e) {
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
        return proxySendResult;
    }

    @Override
    public ProxySendResult sendInTransaction(final ProxyMessage proxyMessage, final ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        ProxySendResult proxySendResult;
        Message message = this.getMessage(proxyMessage);
        try {
            TransactionMQProducer transactionMQProducer = null;
            transactionMQProducer = this.apolloConfigVO != null && ServerMode.isCluster(this.apolloConfigVO.getServerMode()) ? this.getTransactionMQProducerByServerId(proxyMessage.getServerId()) : this.transProductor;
            TransactionSendResult sendResult = transactionMQProducer.sendMessageInTransaction(message, new LocalTransactionExecuter(){

                public LocalTransactionState executeLocalTransactionBranch(Message message, Object arg) {
                    ProxyTransactionStatus transactionStatus = localTransactionExecuter.exec(proxyMessage, arg);
                    if (transactionStatus == ProxyTransactionStatus.COMMIT) {
                        return LocalTransactionState.COMMIT_MESSAGE;
                    }
                    if (transactionStatus == ProxyTransactionStatus.ROLLBACK) {
                        return LocalTransactionState.ROLLBACK_MESSAGE;
                    }
                    if (transactionStatus == ProxyTransactionStatus.UNKNOW) {
                        return LocalTransactionState.UNKNOW;
                    }
                    return LocalTransactionState.UNKNOW;
                }
            }, arg);
            proxySendResult = this.getProxySendResult((SendResult)sendResult);
            this.cacheStore.set(sendResult.getMsgId(), ProxyTransactionStatus.COMMIT.toString(), 600);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("send tran msg msgId={" + proxySendResult.getMsgId() + "}  topic=" + proxyMessage.getSubject() + " tag=" + proxyMessage.getTag() + "  body={" + proxyMessage.getContent() + "}  SendResult={" + proxySendResult.getStatus() + "}");
            }
        }
        catch (Exception e) {
            throw new ProxyMessageException("send subject[" + proxyMessage.getSubject() + "] tag[" + proxyMessage.getTag() + "] error", e);
        }
        return proxySendResult;
    }

    private ProxySendResult getProxySendResult(SendResult sendResult) {
        ProxySendResult proxySendResult = new ProxySendResult();
        proxySendResult.setMsgId(sendResult.getMsgId());
        proxySendResult.setStatus(sendResult.getSendStatus().name());
        return proxySendResult;
    }

    private Message getMessage(ProxyMessage message) {
        Message sendMessage;
        try {
            sendMessage = new Message(message.getSubject(), message.getTag(), message.getContent().getBytes("UTF-8"));
            if (message.getDelaySendTime() > 0) {
                sendMessage.setDelayTimeLevel(this.minL(message.getDelaySendTime()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Convert rocketmq message error", e);
        }
        return sendMessage;
    }

    @Override
    public void send(ProxyMessage message, final ProxySendCallback sendCallback) {
        try {
            DefaultMQProducer defaultMQProducer = null;
            defaultMQProducer = this.apolloConfigVO != null && ServerMode.isCluster(this.apolloConfigVO.getServerMode()) ? this.getMQProducerByServerId(message.getServerId()) : this.producer;
            defaultMQProducer.send(this.getMessage(message), new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    if (sendCallback != null) {
                        sendCallback.onSuccess(RocketMqMessageSender.this.getProxySendResult(sendResult));
                    }
                }

                public void onException(Throwable e) {
                    if (sendCallback != null) {
                        sendCallback.onException(new ProxyExceptionContext(e));
                    }
                }
            });
        }
        catch (Throwable e) {
            if (sendCallback != null) {
                sendCallback.onException(new ProxyExceptionContext(e));
            }
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
    }

    @Override
    public void sendOneway(ProxyMessage message) {
        try {
            DefaultMQProducer defaultMQProducer = null;
            defaultMQProducer = this.apolloConfigVO != null && ServerMode.isCluster(this.apolloConfigVO.getServerMode()) ? this.getMQProducerByServerId(message.getServerId()) : this.producer;
            defaultMQProducer.sendOneway(this.getMessage(message));
        }
        catch (Throwable e) {
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
    }

    @Override
    public void startup() {
        if (this.apolloConfigVO != null && ServerMode.isCluster(this.apolloConfigVO.getServerMode())) {
            Map<String, MQServerProperties> datasource = this.mqProperties.getDatasource();
            if (datasource != null && datasource.size() > 0) {
                try {
                    for (Map.Entry<String, MQServerProperties> entry : datasource.entrySet()) {
                        MQServerProperties mqServerProperties = this.mqProperties.getDatasource().get(entry.getKey());
                        DefaultMQProducer producer = new DefaultMQProducer(mqServerProperties.getInstanceName());
                        producer.setNamesrvAddr(mqServerProperties.getServerUrl());
                        producer.setInstanceName(mqServerProperties.getInstanceName());
                        producer.setRetryTimesWhenSendFailed(0);
                        producer.setRetryTimesWhenSendAsyncFailed(0);
                        producer.start();
                        this.producers.put(entry.getKey(), producer);
                        TransactionMQProducer transProductor = new TransactionMQProducer("tx_" + mqServerProperties.getInstanceName());
                        transProductor.setNamesrvAddr(mqServerProperties.getServerUrl());
                        transProductor.setInstanceName(mqServerProperties.getInstanceName());
                        transProductor.setTransactionCheckListener((TransactionCheckListener)this.transactionCheckerListener);
                        transProductor.setCheckThreadPoolMinSize(5);
                        transProductor.setCheckThreadPoolMaxSize(50);
                        transProductor.setCheckRequestHoldMax(2000);
                        transProductor.start();
                        this.transProductors.put(entry.getKey(), transProductor);
                    }
                }
                catch (MQClientException e) {
                    throw new ProxyMessageException("start product error", e);
                }
            }
            throw new ProxyMessageException("MQ Server \u672a\u914d\u7f6e\uff0cDataSource = [" + datasource.size() + "] ", null);
        }
        if (this.typeTagsMapping.containsKey((Object)ProxyMessageType.TRANSACTION)) {
            this.transProductor = new TransactionMQProducer(((DefaultProxyMessageConfig)this.messageConfig).getId());
            this.transactionCheckerListener = new RocketMqTransactionCheckListener();
            this.transactionCheckerListener.setCacheStore(this.cacheStore);
        } else {
            this.transProductor = null;
        }
        boolean createCommonProductor = false;
        if (this.typeTagsMapping.containsKey((Object)ProxyMessageType.SYNCHRONIZATION)) {
            createCommonProductor = true;
        }
        if (!createCommonProductor && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ASYNCHRONOUS)) {
            createCommonProductor = true;
        }
        if (!createCommonProductor && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ONEWAY)) {
            createCommonProductor = true;
        }
        if (!createCommonProductor && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ORDERED)) {
            createCommonProductor = true;
        }
        this.producer = createCommonProductor ? new DefaultMQProducer(((DefaultProxyMessageConfig)this.messageConfig).getId()) : null;
        try {
            if (this.producer != null) {
                this.producer.setNamesrvAddr(this.messageConfig.getProperties().getProperty("mq.rocket.namesrvaddr", this.apolloConfigVO.getRocketNamesrvaddr()));
                this.producer.setInstanceName(UUID.randomUUID().toString());
                this.producer.setRetryTimesWhenSendFailed(0);
                this.producer.setRetryTimesWhenSendAsyncFailed(0);
                this.producer.start();
            }
            if (this.transProductor != null) {
                this.transProductor.setNamesrvAddr(this.messageConfig.getProperties().getProperty("mq.rocket.namesrvaddr", this.apolloConfigVO.getRocketNamesrvaddr()));
                this.transProductor.setInstanceName(UUID.randomUUID().toString());
                this.transProductor.setTransactionCheckListener((TransactionCheckListener)this.transactionCheckerListener);
                this.transProductor.setCheckThreadPoolMinSize(5);
                this.transProductor.setCheckThreadPoolMaxSize(50);
                this.transProductor.setCheckRequestHoldMax(2000);
                this.transProductor.start();
            }
        }
        catch (MQClientException e) {
            throw new ProxyMessageException("start product[" + this.subject + "] error", e);
        }
    }

    @Override
    public void shutdown() {
        if (this.apolloConfigVO != null && ServerMode.isCluster(this.apolloConfigVO.getServerMode())) {
            if (this.producers != null) {
                for (Map.Entry<String, DefaultMQProducer> entry : this.producers.entrySet()) {
                    DefaultMQProducer defaultMQProducer = this.producers.get(entry.getKey());
                    defaultMQProducer.shutdown();
                }
            }
            if (this.transProductors != null) {
                for (Map.Entry<String, DefaultMQProducer> entry : this.transProductors.entrySet()) {
                    TransactionMQProducer transactionMQProducer = this.transProductors.get(entry.getKey());
                    transactionMQProducer.shutdown();
                }
            }
        } else {
            if (this.producer != null) {
                this.producer.shutdown();
            }
            if (this.transProductor != null) {
                this.transProductor.shutdown();
            }
        }
    }

    private int minL(int time) {
        for (int i = 1; i <= this.data.length; ++i) {
            if (this.data[i - 1] - time > 0) {
                return i - 1;
            }
            if (this.data[i - 1] - time == 0) {
                return i;
            }
            if (i != this.data.length) continue;
            return i;
        }
        return 14;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApolloConfigVO bean;
        this.apolloConfigVO = bean = (ApolloConfigVO)applicationContext.getBean(ApolloConfigVO.class);
        this.cacheStore = (CacheStore)applicationContext.getBean(CacheStore.class);
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
    }
}

