/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rabbitmq;

import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ext.rabbitmq.RabbitMQMessageConsumerRegister;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.Set;

public class RabbitMqMessageListener
extends DefaultConsumer {
    private MqRecordLog mqRecordLog;
    private final Set<IProxyMessageConsumerWrapper> localConsumers;
    private String queueName;
    private Channel channel;
    private boolean autoAck;
    private String consumerTag;

    public RabbitMqMessageListener(String queueName, boolean autoAck, String consumerTag, Channel channel, Set<IProxyMessageConsumerWrapper> consumerWrappers, MqRecordLog mqRecordLog) {
        super(channel);
        this.mqRecordLog = mqRecordLog;
        this.queueName = queueName;
        this.autoAck = autoAck;
        this.consumerTag = consumerTag;
        this.channel = channel;
        this.localConsumers = consumerWrappers;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        this.processMessage(this.localConsumers, new String(body), envelope, this.channel);
    }

    protected void processMessage(Set<IProxyMessageConsumerWrapper> localConsumers, String msg, Envelope envelope, Channel channel) {
        ProxyMessage proxyMessage = new ProxyMessage();
        try {
            ProxyMessage message = new ProxyMessage(envelope.getRoutingKey(), this.queueName, String.valueOf(envelope.getDeliveryTag()), this.consumerTag, msg);
            proxyMessage = RabbitMQMessageConsumerRegister.getMessage(message);
            for (ProxyMessageConsumer proxyMessageConsumer : localConsumers) {
                proxyMessageConsumer.onMessage(proxyMessage);
            }
            proxyMessage.setStatus(2);
            this.mqRecordLog.thread(proxyMessage, this.mqRecordLog);
            channel.basicAck(envelope.getDeliveryTag(), false);
        }
        catch (Exception e) {
            proxyMessage.setStatus(3);
            this.mqRecordLog.thread(proxyMessage, this.mqRecordLog);
            try {
                e.printStackTrace();
                channel.basicNack(envelope.getDeliveryTag(), false, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Set<IProxyMessageConsumerWrapper> getLocalConsumers() {
        return this.localConsumers;
    }

    public String toString() {
        return "RabbitMqMessageListener";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.toString().equals(obj.toString());
    }
}

