/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.constants.LogUtils;
import com.ohaotian.plugin.mq.proxy.constants.MessageConfigUtils;
import com.ohaotian.plugin.mq.proxy.impl.ProxyMessageSenderWrapper;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ProxyProducerFactoryBean
implements FactoryBean,
ApplicationContextAware {
    private ProxyMessageConfig messageConfig;
    private ProxyMessageSenderWrapper messageSenderWrapper;
    private ProxyMessageProducer messageProducer;
    private String defaultStrategy = "RocketMQ";
    private String enable = "true";
    private boolean isShowEnable = false;
    private static final Logger logger = LoggerFactory.getLogger(ProxyProducerFactoryBean.class);
    private ApolloConfigVO apolloConfigVO;

    public Object getObject() throws Exception {
        ProxyMessageType[] messageTypes;
        Boolean disable = MessageConfigUtils.isDisable(this.enable);
        if (disable.booleanValue()) {
            if (this.isShowEnable) {
                LogUtils.info(logger, "\u7981\u7528\u63d2\u4ef6\uff0c\u8fd4\u56de\u9ed8\u8ba4\u751f\u4ea7\u8005");
            }
            this.defaultStrategy = "DefaultMQ";
        } else if (this.isShowEnable) {
            LogUtils.info(logger, "\u542f\u7528\u63d2\u4ef6\uff0c\u542f\u7528\u751f\u4ea7\u8005");
        }
        this.isShowEnable = true;
        if (this.messageProducer != null) {
            return this.messageProducer;
        }
        HashSet<String> tagSet = new HashSet<String>();
        String[] tags = this.messageConfig.getTags();
        ProxyProducerFactoryBean.trans2TagSet(tagSet, tags);
        HashMap<ProxyMessageType, Set<String>> typeTagsMapping = new HashMap<ProxyMessageType, Set<String>>();
        for (ProxyMessageType messageType : messageTypes = this.messageConfig.supportMessageTypes()) {
            typeTagsMapping.put(messageType, tagSet);
        }
        String strategy = this.apolloConfigVO.getStrategy();
        if (strategy == null || "".equals(strategy)) {
            strategy = this.defaultStrategy;
        }
        this.messageSenderWrapper = new ProxyMessageSenderWrapper(strategy, this.messageConfig, typeTagsMapping);
        this.messageProducer = (ProxyMessageProducer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ProxyMessageProducer.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)ProxyProducerFactoryBean.this.messageSenderWrapper, args);
            }
        });
        return this.messageProducer;
    }

    public void startup() {
        if (this.messageSenderWrapper == null) {
            try {
                this.getObject();
            }
            catch (Exception e) {
                throw new IllegalStateException("Init message productor error", e);
            }
        }
        this.messageSenderWrapper.startup();
    }

    public void shutdown() {
        if (this.messageSenderWrapper != null) {
            this.messageSenderWrapper.shutdown();
        }
    }

    static void trans2TagSet(Set<String> tagSet, String[] tags) {
        if (null == tags) {
            return;
        }
        for (String tag : tags) {
            if (tagSet.contains("*")) break;
            if (tag.equals("*")) {
                tagSet.clear();
                tagSet.add(tag);
                break;
            }
            if (tagSet.contains(tag)) continue;
            tagSet.add(tag);
        }
    }

    public Class<?> getObjectType() {
        return ProxyMessageProducer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMessageConfig(ProxyMessageConfig messageConfig) {
        this.messageConfig = messageConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.messageSenderWrapper == null) {
            try {
                this.getObject();
            }
            catch (Exception e) {
                throw new IllegalStateException("Init message productor error", e);
            }
        }
        this.messageSenderWrapper.setApplicationContext(applicationContext);
    }
}

