/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.redismq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import java.io.IOException;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

public class RedisMQMessageListener
extends JedisPubSub {
    private MqRecordLog mqRecordLog;
    private final JedisPool jedisPool;
    private final ThreadLocal<ObjectMapper> objectMapperThreadLocal = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };
    private Set<IProxyMessageConsumerWrapper> consumerWrapperList;

    public RedisMQMessageListener(JedisPool jedisPool, Set<IProxyMessageConsumerWrapper> consumerWrapperList, MqRecordLog mqRecordLog) {
        this.mqRecordLog = mqRecordLog;
        this.consumerWrapperList = consumerWrapperList;
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unsetOneConsumer(ProxyMessage message) {
        boolean result = false;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            result = jedis.del(message.getMessageId()).intValue() > 0;
        }
        return result;
    }

    public void onMessage(String channel, String message) {
        this.processMessage(message);
    }

    public void onPMessage(String pattern, String channel, String message) {
        this.processMessage(message);
    }

    private void processMessage(String message) {
        ProxyMessage proxyMessage = new ProxyMessage();
        try {
            proxyMessage = (ProxyMessage)this.objectMapperThreadLocal.get().readValue(message, ProxyMessage.class);
            if (this.unsetOneConsumer(proxyMessage)) {
                for (IProxyMessageConsumerWrapper messageConsumer : this.consumerWrapperList) {
                    if (!messageConsumer.needWrapper(proxyMessage.getSubject(), proxyMessage.getTag())) continue;
                    messageConsumer.onMessage(proxyMessage);
                }
            }
            proxyMessage.setStatus(2);
            this.mqRecordLog.thread(proxyMessage, this.mqRecordLog);
        }
        catch (IOException e) {
            proxyMessage.setStatus(3);
            this.mqRecordLog.thread(proxyMessage, this.mqRecordLog);
            throw new RuntimeException("Redis parse value error", e);
        }
    }
}

