/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rocketmq;

import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.ext.rocketmq.RocketMQMessageListener;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.ohaotian.plugin.mq.proxy.impl.MQUtils;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class RocketMQMessageConsumerRegister
implements MQRegister,
ApplicationContextAware {
    private Properties mergedProps = new Properties();
    private String defaultValue = "defaultValue";
    private boolean started;
    private DefaultMQPushConsumer consumer;
    @Autowired
    private ApolloConfigVO apolloConfigVO;
    private MqRecordLog mqRecordLog;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void register(ConsumerRegisterInfo consumerInfo, ApolloConfigVO apolloConfigVO) {
        ProxyMessageType[] messageTypes;
        String subject = consumerInfo.getSubject();
        for (ProxyMessageType messageType : messageTypes = consumerInfo.getMessageTypes()) {
            if (this.supportConcurrently(messageType)) continue;
            throw new UnsupportedOperationException("Unsuppoorted messageType[" + (Object)((Object)messageType) + "] for subject[" + consumerInfo.getSubject() + "]");
        }
        this.consumer = new DefaultMQPushConsumer(consumerInfo.getCid());
        this.consumer.setNamesrvAddr(consumerInfo.getProperties().getProperty("mq.rocket.namesrvaddr", apolloConfigVO.getRocketNamesrvaddr()));
        try {
            this.consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
            this.consumer.subscribe(subject, MQUtils.tags2Line(consumerInfo.getTags()));
            this.consumer.setInstanceName(UUID.randomUUID().toString());
        }
        catch (MQClientException e) {
            throw new IllegalStateException("Consumer[" + consumerInfo.getSubject() + "] subscribe error", e);
        }
        this.consumer.registerMessageListener((MessageListenerConcurrently)new RocketMQMessageListener(consumerInfo.getConsumerWrappers(), this.mqRecordLog));
        this.consumer.registerMessageListener((MessageListenerOrderly)new RocketMQMessageListener(consumerInfo.getConsumerWrappers(), this.mqRecordLog));
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    protected static ProxyMessage getMessage(MessageExt messageExt) {
        ProxyMessage message;
        try {
            message = new ProxyMessage(messageExt.getTopic(), messageExt.getTags(), new String(messageExt.getBody(), "UTF-8"));
            message.setMessageId(messageExt.getMsgId());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("MessageExt 2 ProxyMessage Error", e);
        }
        return message;
    }

    @Override
    public boolean support(String strategy) {
        return RocketMQMessageConsumerRegister.strategySupported(strategy);
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isRocketMQ(strategy);
    }

    @Override
    public void startup() {
        if (this.started) {
            return;
        }
        try {
            this.consumer.start();
        }
        catch (MQClientException e) {
            throw new IllegalStateException("Start MQConsumer error", e);
        }
        this.started = true;
    }

    @Override
    public void shutdown() {
        if (!this.started) {
            return;
        }
        this.consumer.shutdown();
        this.started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.mqRecordLog = (MqRecordLog)applicationContext.getBean(MqRecordLog.class);
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
    }
}

