/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.aliyunmq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.ohaotian.license.verify.service.LicenseVerifyService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyExceptionContext;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.ext.aliyunmq.AliyunMqTransactionCheckerListener;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageException;
import com.ohaotian.plugin.mq.proxy.status.ProxyTransactionStatus;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AliyunMqMessageSender
implements ProxyMessageProducerEx,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private boolean started;
    private Properties mergedProps = new Properties();
    private String defaultValue = "defaultValue";
    private Producer producer;
    private TransactionProducer transProductor;
    private ProxyMessageConfig messageConfig;
    private final String subject;
    private final Map<ProxyMessageType, Set<String>> typeTagsMapping;
    private AliyunMqTransactionCheckerListener transactionCheckerListener;
    private CacheStore cacheStore;
    private ApolloConfigVO apolloConfigVO;
    private LicenseVerifyService licenseVerifyService;

    public AliyunMqMessageSender(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        this.logger.info("[" + this.getClass().getName() + "] required properties[mq.producerId|mq.accessKey|mq.secretKey|mq.onsAddr|mq.sendMsgTimeoutMillis]");
        this.subject = messageConfig.getSubject();
        this.messageConfig = messageConfig;
        this.typeTagsMapping = typeTagsMapping;
    }

    @Override
    public ProxySendResult send(ProxyMessage message) {
        ProxySendResult proxySendResult;
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        this.checkStatus(message, ProxyMessageType.SYNCHRONIZATION);
        try {
            SendResult sendResult = this.producer.send(this.getMessage(message));
            proxySendResult = this.getProxySendResult(sendResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
        return proxySendResult;
    }

    @Override
    public ProxySendResult sendInTransaction(final ProxyMessage proxyMessage, final ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        ProxySendResult proxySendResult;
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        this.checkStatus(proxyMessage, ProxyMessageType.TRANSACTION);
        Message message = this.getMessage(proxyMessage);
        try {
            SendResult sendResult = this.transProductor.send(message, new LocalTransactionExecuter(){

                public TransactionStatus execute(Message msg, Object arg) {
                    ProxyTransactionStatus transactionStatus = localTransactionExecuter.exec(proxyMessage, arg);
                    if (transactionStatus == ProxyTransactionStatus.COMMIT) {
                        return TransactionStatus.CommitTransaction;
                    }
                    if (transactionStatus == ProxyTransactionStatus.ROLLBACK) {
                        return TransactionStatus.RollbackTransaction;
                    }
                    if (transactionStatus == ProxyTransactionStatus.UNKNOW) {
                        return TransactionStatus.Unknow;
                    }
                    return TransactionStatus.Unknow;
                }
            }, arg);
            proxySendResult = this.getProxySendResult(sendResult);
            this.cacheStore.set(message.getMsgID(), ProxyTransactionStatus.COMMIT.toString(), 600);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("send tran msg msgId={" + message.getMsgID() + "}  topic=" + proxyMessage.getSubject() + " tag=" + proxyMessage.getTag() + "  body={" + proxyMessage.getContent() + "}  SendResult={" + proxySendResult.getStatus() + "}");
            }
        }
        catch (Exception e) {
            this.cacheStore.set(message.getMsgID(), ProxyTransactionStatus.ROLLBACK.toString(), 600);
            throw new ProxyMessageException("send subject[" + proxyMessage.getSubject() + "] tag[" + proxyMessage.getTag() + "] error", e);
        }
        return proxySendResult;
    }

    private ProxySendResult getProxySendResult(SendResult sendResult) {
        ProxySendResult proxySendResult = new ProxySendResult();
        proxySendResult.setMsgId(sendResult.getMessageId());
        proxySendResult.setStatus("SEND_OK");
        return proxySendResult;
    }

    private Message getMessage(ProxyMessage message) {
        Message sendMessage;
        try {
            sendMessage = new Message(message.getSubject(), message.getTag(), message.getKey(), message.getContent().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Convert rocketmq message error", e);
        }
        return sendMessage;
    }

    @Override
    public void send(ProxyMessage message, final ProxySendCallback sendCallback) {
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        this.checkStatus(message, ProxyMessageType.ASYNCHRONOUS);
        try {
            this.producer.sendAsync(this.getMessage(message), new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    if (sendCallback != null) {
                        sendCallback.onSuccess(AliyunMqMessageSender.this.getProxySendResult(sendResult));
                    }
                }

                public void onException(OnExceptionContext context) {
                    if (sendCallback != null) {
                        sendCallback.onException(new ProxyExceptionContext((Throwable)context.getException()));
                    }
                }
            });
        }
        catch (Throwable e) {
            if (sendCallback != null) {
                sendCallback.onException(new ProxyExceptionContext(e));
            }
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
    }

    private void checkStatus(ProxyMessage message, ProxyMessageType proxyMessageType) {
    }

    @Override
    public void sendOneway(ProxyMessage message) {
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        this.checkStatus(message, ProxyMessageType.ONEWAY);
        try {
            this.producer.sendOneway(this.getMessage(message));
        }
        catch (Throwable e) {
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
    }

    @Override
    public void startup() {
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Properties config = new Properties();
        Properties consumerProps = this.messageConfig.getProperties();
        config.put("ProducerId", ((DefaultProxyMessageConfig)this.messageConfig).getId());
        config.put("AccessKey", consumerProps.getProperty("mq.accessKey", this.apolloConfigVO.getAccessKey()));
        config.put("SecretKey", consumerProps.getProperty("mq.secretKey", this.apolloConfigVO.getSecretKey()));
        config.put("SendMsgTimeoutMillis", consumerProps.getProperty("mq.sendMsgTimeoutMillis", this.apolloConfigVO.getSendMsgTimeoutMillis()));
        if (StringUtils.isEmpty((Object)this.apolloConfigVO.getSupportGID())) {
            config.put("ProducerId", ((DefaultProxyMessageConfig)this.messageConfig).getId());
            config.put("ONSAddr", consumerProps.getProperty("mq.onsAddr", this.apolloConfigVO.getOnsAddr()));
        } else {
            config.put("NAMESRV_ADDR", consumerProps.getProperty("mq.onsAddr", this.apolloConfigVO.getOnsAddr()));
        }
        if (this.typeTagsMapping.containsKey((Object)ProxyMessageType.TRANSACTION)) {
            this.transactionCheckerListener = new AliyunMqTransactionCheckerListener();
            this.transactionCheckerListener.setCacheStore(this.cacheStore);
            this.transProductor = ONSFactory.createTransactionProducer((Properties)config, (LocalTransactionChecker)this.transactionCheckerListener);
        } else {
            this.transProductor = null;
        }
        boolean createCommonProductor = false;
        if (this.typeTagsMapping.containsKey((Object)ProxyMessageType.SYNCHRONIZATION)) {
            createCommonProductor = true;
        }
        if (!createCommonProductor && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ASYNCHRONOUS)) {
            createCommonProductor = true;
        }
        if (!createCommonProductor && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ONEWAY)) {
            createCommonProductor = true;
        }
        if (!createCommonProductor && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ORDERED)) {
            createCommonProductor = true;
        }
        this.producer = createCommonProductor ? ONSFactory.createProducer((Properties)config) : null;
        if (this.producer != null) {
            this.producer.start();
        }
        if (this.transProductor != null) {
            this.transProductor.start();
        }
    }

    @Override
    public void shutdown() {
        if (this.producer != null) {
            this.producer.shutdown();
        }
        if (this.transProductor != null) {
            this.transProductor.shutdown();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApolloConfigVO bean;
        this.apolloConfigVO = bean = (ApolloConfigVO)applicationContext.getBean(ApolloConfigVO.class);
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
        this.licenseVerifyService = (LicenseVerifyService)applicationContext.getBean(LicenseVerifyService.class);
        this.cacheStore = (CacheStore)applicationContext.getBean(CacheStore.class);
    }
}

