/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class RabbitMQUtil
implements ApplicationContextAware {
    private static Properties mergedProps = new Properties();

    public static Channel getChannelInstance(String connectionDescription, Properties properties) {
        try {
            ConnectionFactory connectionFactory = RabbitMQUtil.getConnectionFactory(properties);
            Connection connection = connectionFactory.newConnection(connectionDescription);
            return connection.createChannel();
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6Channel\u8fde\u63a5\u5931\u8d25" + e.getMessage());
        }
    }

    private static ConnectionFactory getConnectionFactory(Properties properties) {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost(properties.getProperty("mq.onsAddr").split(":")[0]);
        connectionFactory.setPort(Integer.parseInt(properties.getProperty("mq.onsAddr").split(":")[1]));
        connectionFactory.setVirtualHost(properties.getProperty("mq.rabbit.virtualHost"));
        connectionFactory.setUsername(properties.getProperty("mq.rabbit.username"));
        connectionFactory.setPassword(properties.getProperty("mq.rabbit.password"));
        connectionFactory.setAutomaticRecoveryEnabled(true);
        connectionFactory.setNetworkRecoveryInterval(5000);
        return connectionFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)mergedProps);
            }
        }
    }
}

