/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rocketmq;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageLog;
import com.ohaotian.plugin.mq.proxy.ext.rocketmq.RocketMQMessageConsumerRegister;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import java.util.List;
import java.util.Set;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQMessageListener
implements MessageListenerConcurrently,
MessageListenerOrderly {
    private static final Logger log = LoggerFactory.getLogger(RocketMQMessageListener.class);
    private final Set<IProxyMessageConsumerWrapper> localConsumers;
    private MqRecordLog mqRecordLog;

    RocketMQMessageListener(Set<IProxyMessageConsumerWrapper> localConsumers, MqRecordLog mqRecordLog) {
        this.mqRecordLog = mqRecordLog;
        this.localConsumers = localConsumers;
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> messageExts, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        this.processMessage(messageExts, this.localConsumers);
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> messageExts, ConsumeOrderlyContext consumeOrderlyContext) {
        this.processMessage(messageExts, this.localConsumers);
        return ConsumeOrderlyStatus.SUCCESS;
    }

    private void processMessage(List<MessageExt> messageExts, Set<IProxyMessageConsumerWrapper> localConsumers) {
        for (MessageExt messageExt : messageExts) {
            ProxyMessage message = RocketMQMessageConsumerRegister.getMessage(messageExt);
            try {
                ProxyMessageLog proxyMessageLog = new ProxyMessageLog(message);
                log.info("\u63a5\u6536\u6d88\u606fmessage=" + JSON.toJSONString((Object)proxyMessageLog));
                for (IProxyMessageConsumerWrapper proxyMessageConsumer : localConsumers) {
                    if (!proxyMessageConsumer.needWrapper(message.getSubject(), message.getTag())) continue;
                    proxyMessageConsumer.onMessage(message);
                }
                message.setStatus(2);
                this.mqRecordLog.thread(message, this.mqRecordLog);
            }
            catch (RuntimeException e) {
                message.setStatus(3);
                this.mqRecordLog.thread(message, this.mqRecordLog);
                throw new RuntimeException(e);
            }
        }
    }
}

