/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.constants.LogUtils;
import com.ohaotian.plugin.mq.proxy.impl.ProxyMessageRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyMessageProducer
implements ProxyMessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(ProxyMessageRegister.class);

    @Override
    public ProxySendResult send(ProxyMessage message) {
        this.showDisableTip(message);
        return this.makeSendFail(message);
    }

    @Override
    public void send(ProxyMessage message, ProxySendCallback sendCallback) {
        this.showDisableTip(message);
        sendCallback.onSuccess(this.makeSendFail(message));
    }

    @Override
    public void sendOneway(ProxyMessage message) {
        this.showDisableTip(message);
    }

    @Override
    public ProxySendResult sendInTransaction(ProxyMessage message, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        this.showDisableTip(message);
        return this.makeSendFail(message);
    }

    private void showDisableTip(ProxyMessage message) {
        LogUtils.warn(logger, "\u5df2\u7981\u7528\u63d2\u4ef6\uff0c\u4e0d\u53d1\u9001\u6d88\u606f\uff0c\u5982\u679c\u60a8\u8981\u542f\u7528\u63d2\u4ef6\uff0c\u8bf7\u4fee\u6539 [mq.enable] \u7684\u503c\u4e3a [true]");
        LogUtils.debug(logger, "\u672a\u53d1\u9001\u7684\u6d88\u606f\u4e3a\uff1a", message);
    }

    private ProxySendResult makeSendFail(ProxyMessage message) {
        ProxySendResult result = new ProxySendResult();
        result.setMsgId(message.getMessageId());
        result.setStatus("SEND_FAIL");
        return result;
    }
}

