/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.ext.ExtInfo;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.impl.MQUtils;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.util.ExecutorProcessPool;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ProxyMessageSenderWrapper
implements ProxyMessageProducerEx,
ApplicationContextAware {
    private final ProxyMessageProducerEx localMessageSender;
    private boolean started;
    private MqRecordLog mqRecordLog;

    ProxyMessageSenderWrapper(String strategy, ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        ExtInfo extInfo = MQUtils.getExtInfoMapping().get(strategy);
        if (extInfo == null) {
            throw new IllegalStateException("mq.strategy[" + strategy + "] unsupported");
        }
        this.localMessageSender = extInfo.newProducer(messageConfig, typeTagsMapping);
    }

    @Override
    public ProxySendResult send(final ProxyMessage message) {
        ProxySendResult send = new ProxySendResult();
        try {
            send = this.localMessageSender.send(message);
            message.setStatus(0);
            message.setMessageId(send.getMsgId());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProxyMessageSenderWrapper.this.mqRecordLog.addMqRecord(message);
                }
            };
            ExecutorProcessPool.getInstance().executeByCustomThread(runnable);
        }
        catch (ZTBusinessException e) {
            message.setStatus(1);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProxyMessageSenderWrapper.this.mqRecordLog.addMqRecord(message);
                }
            };
            ExecutorProcessPool.getInstance().executeByCustomThread(runnable);
            throw new ZTBusinessException("mq\u53d1\u9001\u6d88\u606f\u5931\u8d25," + e.resolverException());
        }
        catch (Exception e) {
            message.setStatus(1);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProxyMessageSenderWrapper.this.mqRecordLog.addMqRecord(message);
                }
            };
            ExecutorProcessPool.getInstance().executeByCustomThread(runnable);
            throw new ZTBusinessException("mq\u53d1\u9001\u6d88\u606f\u5931\u8d25," + e.getMessage());
        }
        return send;
    }

    @Override
    public void send(ProxyMessage message, ProxySendCallback sendCallback) {
        this.localMessageSender.send(message, sendCallback);
    }

    @Override
    public void sendOneway(ProxyMessage message) {
        this.localMessageSender.sendOneway(message);
    }

    @Override
    public ProxySendResult sendInTransaction(ProxyMessage proxyMessage, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        return this.localMessageSender.sendInTransaction(proxyMessage, localTransactionExecuter, arg);
    }

    @Override
    public void startup() {
        if (this.started) {
            return;
        }
        this.localMessageSender.startup();
        this.started = true;
    }

    @Override
    public void shutdown() {
        if (!this.started) {
            return;
        }
        this.localMessageSender.shutdown();
        this.started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.mqRecordLog = (MqRecordLog)applicationContext.getBean(MqRecordLog.class);
        if (this.localMessageSender instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.localMessageSender).setApplicationContext(applicationContext);
        }
    }
}

