/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.aliyunmq;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageLog;
import com.ohaotian.plugin.mq.proxy.ext.aliyunmq.AliyunMQMessageConsumerRegister;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(AliyunMessageListener.class);
    private final Set<IProxyMessageConsumerWrapper> localConsumers;
    private MqRecordLog mqRecordLog;

    AliyunMessageListener(Set<IProxyMessageConsumerWrapper> localConsumers, MqRecordLog mqRecordLog) {
        this.mqRecordLog = mqRecordLog;
        this.localConsumers = localConsumers;
    }

    public Action consume(Message message, ConsumeContext consumeContext) {
        this.processMessage(message, this.localConsumers);
        return Action.CommitMessage;
    }

    public String toString() {
        return "AliyunMessageListener";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this.toString().equals(obj.toString());
    }

    private void processMessage(Message aliyunMessage, Set<IProxyMessageConsumerWrapper> localConsumers) {
        ProxyMessage message = AliyunMQMessageConsumerRegister.getMessage(aliyunMessage);
        try {
            ProxyMessageLog proxyMessageLog = new ProxyMessageLog(message);
            log.info("\u63a5\u6536\u6d88\u606fmessage=" + JSON.toJSONString((Object)proxyMessageLog));
            for (ProxyMessageConsumer proxyMessageConsumer : localConsumers) {
                proxyMessageConsumer.onMessage(message);
            }
            message.setStatus(2);
            this.mqRecordLog.thread(message, this.mqRecordLog);
        }
        catch (RuntimeException e) {
            message.setStatus(3);
            this.mqRecordLog.thread(message, this.mqRecordLog);
            throw new RuntimeException(e);
        }
    }
}

