/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.sofamq;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageLog;
import com.ohaotian.plugin.mq.proxy.ext.sofamq.SofaMqMessageConsumerRegister;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import io.openmessaging.api.Action;
import io.openmessaging.api.ConsumeContext;
import io.openmessaging.api.Message;
import io.openmessaging.api.MessageListener;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SofaMqMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(SofaMqMessageListener.class);
    private final Set<IProxyMessageConsumerWrapper> localConsumers;
    private MqRecordLog mqRecordLog;

    public SofaMqMessageListener(Set<IProxyMessageConsumerWrapper> localConsumers, MqRecordLog mqRecordLog) {
        this.mqRecordLog = mqRecordLog;
        this.localConsumers = localConsumers;
    }

    public Action consume(Message message, ConsumeContext consumeContext) {
        this.processMessage(message, this.localConsumers);
        return Action.CommitMessage;
    }

    private void processMessage(Message sofaMessage, Set<IProxyMessageConsumerWrapper> localConsumers) {
        ProxyMessage message = SofaMqMessageConsumerRegister.getMessage(sofaMessage);
        try {
            ProxyMessageLog proxyMessageLog = new ProxyMessageLog(message);
            log.info("\u63a5\u6536\u6d88\u606fmessage=" + JSON.toJSONString((Object)proxyMessageLog));
            for (ProxyMessageConsumer proxyMessageConsumer : localConsumers) {
                proxyMessageConsumer.onMessage(message);
            }
            message.setStatus(2);
        }
        catch (RuntimeException e) {
            message.setStatus(3);
            throw new RuntimeException(e);
        }
        finally {
            this.mqRecordLog.thread(message, this.mqRecordLog);
        }
    }

    public String toString() {
        return "SofaMQMessageListener";
    }
}

