/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.sofamq;

import com.ohaotian.license.verify.service.LicenseVerifyService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyExceptionContext;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.ext.sofamq.SofaMqTransactionCheckerListener;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageException;
import com.ohaotian.plugin.mq.proxy.status.ProxyTransactionStatus;
import io.openmessaging.api.Message;
import io.openmessaging.api.OMS;
import io.openmessaging.api.OnExceptionContext;
import io.openmessaging.api.Producer;
import io.openmessaging.api.SendCallback;
import io.openmessaging.api.SendResult;
import io.openmessaging.api.transaction.LocalTransactionChecker;
import io.openmessaging.api.transaction.TransactionProducer;
import io.openmessaging.api.transaction.TransactionStatus;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class SofaMqMessageSender
implements ProxyMessageProducerEx,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SofaMqMessageSender.class);
    private LicenseVerifyService licenseVerifyService;
    private Environment environment;
    private ProxyMessageConfig messageConfig;
    private final String subject;
    private final Map<ProxyMessageType, Set<String>> typeTagsMapping;
    private SofaMqTransactionCheckerListener transactionCheckerListener;
    private CacheStore cacheStore;
    private TransactionProducer transProducter;
    private Producer producer;
    private ApolloConfigVO apolloConfigVO;

    public SofaMqMessageSender(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        log.info("[" + this.getClass().getName() + "] required properties[mq.dataCenter|mq.instanceId|mq.accessKey|mq.secretKey]");
        this.subject = messageConfig.getSubject();
        this.messageConfig = messageConfig;
        this.typeTagsMapping = typeTagsMapping;
    }

    @Override
    public void startup() {
        log.debug("\u5f00\u59cb\u521b\u5efa\u751f\u4ea7\u8005\u5bf9\u8c61bean");
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Properties config = new Properties();
        config.put("accessKey", this.environment.getProperty("mq.accessKey"));
        config.put("secretKey", this.environment.getProperty("mq.secretKey"));
        config.put("endpoint", this.environment.getProperty("mq.endpoint"));
        config.put("instanceId", this.environment.getProperty("mq.instanceId"));
        config.put("dataCenter", this.environment.getProperty("mq.dataCenter"));
        if (!StringUtils.isEmpty((Object)this.apolloConfigVO.getSupportGID())) {
            config.put("groupId", ((DefaultProxyMessageConfig)this.messageConfig).getId());
        }
        if (this.typeTagsMapping.containsKey((Object)ProxyMessageType.TRANSACTION)) {
            this.transactionCheckerListener = new SofaMqTransactionCheckerListener();
            this.transactionCheckerListener.setCacheStore(this.cacheStore);
            this.transProducter = OMS.builder().driver("sofamq").build(config).createTransactionProducer(config, (LocalTransactionChecker)this.transactionCheckerListener);
        } else {
            this.transProducter = null;
        }
        boolean createCommonProducer = false;
        if (this.typeTagsMapping.containsKey((Object)ProxyMessageType.SYNCHRONIZATION)) {
            createCommonProducer = true;
        }
        if (!createCommonProducer && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ASYNCHRONOUS)) {
            createCommonProducer = true;
        }
        if (!createCommonProducer && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ONEWAY)) {
            createCommonProducer = true;
        }
        if (!createCommonProducer && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ORDERED)) {
            createCommonProducer = true;
        }
        this.producer = createCommonProducer ? OMS.builder().driver("sofamq").build(config).createProducer(config) : null;
        try {
            if (this.producer != null) {
                this.producer.start();
            }
            if (this.transProducter != null) {
                this.transProducter.start();
            }
        }
        catch (Exception e) {
            throw new ProxyMessageException("start product[" + this.subject + "] error", e);
        }
    }

    @Override
    public void shutdown() {
        if (this.producer != null) {
            this.producer.shutdown();
        }
        if (this.transProducter != null) {
            this.transProducter.shutdown();
        }
    }

    @Override
    public ProxySendResult send(ProxyMessage message) {
        ProxySendResult proxySendResult;
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        try {
            proxySendResult = this.getProxySendResult(this.producer.send(this.getMessage(message)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
        return proxySendResult;
    }

    private ProxySendResult getProxySendResult(SendResult sendResult) {
        ProxySendResult proxySendResult = new ProxySendResult();
        proxySendResult.setMsgId(sendResult.getMessageId());
        proxySendResult.setStatus("SEND_OK");
        return proxySendResult;
    }

    private Message getMessage(ProxyMessage message) {
        Message sendMessage;
        try {
            sendMessage = new Message(message.getSubject(), message.getTag(), message.getKey(), message.getContent().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Convert sofamq message error", e);
        }
        return sendMessage;
    }

    @Override
    public void send(ProxyMessage message, final ProxySendCallback sendCallback) {
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        try {
            this.producer.sendAsync(this.getMessage(message), new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    log.debug("send async message success!!");
                    if (sendCallback != null) {
                        sendCallback.onSuccess(SofaMqMessageSender.this.getProxySendResult(sendResult));
                    }
                }

                public void onException(OnExceptionContext onExceptionContext) {
                    if (sendCallback != null) {
                        sendCallback.onException(new ProxyExceptionContext((Throwable)onExceptionContext.getException()));
                    }
                }
            });
        }
        catch (Throwable e) {
            if (sendCallback != null) {
                sendCallback.onException(new ProxyExceptionContext(e));
            }
            throw new ProxyMessageException("send sofa subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
    }

    @Override
    public void sendOneway(ProxyMessage message) {
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        try {
            this.producer.sendOneway(this.getMessage(message));
        }
        catch (Throwable e) {
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
    }

    @Override
    public ProxySendResult sendInTransaction(ProxyMessage proxyMessage, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        ProxySendResult proxySendResult;
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Message message = this.getMessage(proxyMessage);
        try {
            SendResult sendResult = this.transProducter.send(message, (msg, arg1) -> {
                ProxyTransactionStatus transactionStatus = localTransactionExecuter.exec(proxyMessage, arg1);
                if (transactionStatus == ProxyTransactionStatus.COMMIT) {
                    return TransactionStatus.CommitTransaction;
                }
                if (transactionStatus == ProxyTransactionStatus.ROLLBACK) {
                    log.debug("\u672c\u5730\u4e8b\u52a1\u63d0\u4ea4\u5931\u8d25\uff0c\u8fdb\u884c\u56de\u6eda\u5904\u7406\uff01");
                    return TransactionStatus.RollbackTransaction;
                }
                if (transactionStatus == ProxyTransactionStatus.UNKNOW) {
                    return TransactionStatus.Unknow;
                }
                return TransactionStatus.Unknow;
            }, arg);
            proxySendResult = this.getProxySendResult(sendResult);
            this.cacheStore.set(sendResult.getMessageId(), ProxyTransactionStatus.COMMIT.toString(), 600);
            if (log.isDebugEnabled()) {
                log.debug("send tran msg msgId={" + proxySendResult.getMsgId() + "}  topic=" + proxyMessage.getSubject() + " tag=" + proxyMessage.getTag() + "  body={" + proxyMessage.getContent() + "}  SendResult={" + proxySendResult.getStatus() + "}");
            }
        }
        catch (Exception e) {
            throw new ProxyMessageException("send subject[" + proxyMessage.getSubject() + "] tag[" + proxyMessage.getTag() + "] error", e);
        }
        return proxySendResult;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.licenseVerifyService = (LicenseVerifyService)applicationContext.getBean(LicenseVerifyService.class);
        this.cacheStore = (CacheStore)applicationContext.getBean(CacheStore.class);
        this.apolloConfigVO = (ApolloConfigVO)applicationContext.getBean(ApolloConfigVO.class);
        this.environment = applicationContext.getEnvironment();
    }
}

