/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy;

import com.alibaba.druid.pool.DruidDataSource;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.util.ExecutorProcessPool;
import com.ohaotian.plugin.mq.proxy.util.MqSequence;
import java.time.LocalDateTime;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class MqRecordLog
implements ApplicationContextAware {
    private ApolloConfigVO apolloConfigVO;
    private JdbcTemplate jdbcTemplate;

    public void addMqRecord(ProxyMessage message) {
        if ("true".equals(this.apolloConfigVO.getDataSourceEnable())) {
            String[] sqls;
            if (StringUtils.isEmpty((CharSequence)message.getMessageId())) {
                message.setMessageId(String.valueOf(MqSequence.getInstance().nextId()));
            }
            if (StringUtils.isEmpty((CharSequence)message.getSubject())) {
                throw new ZTBusinessException("*******topic\u4e0d\u80fd\u4e3a\u7a7a********");
            }
            if (StringUtils.isEmpty((CharSequence)message.getTag())) {
                throw new ZTBusinessException("********tag\u4e0d\u80fd\u4e3a\u7a7a********");
            }
            if (StringUtils.isEmpty((CharSequence)message.getContent())) {
                throw new ZTBusinessException("*******\u6d88\u606f\u4e0d\u80fd\u4e3a\u7a7a*******");
            }
            if (StringUtils.isEmpty((CharSequence)message.getQueueName())) {
                message.setQueueName("");
            }
            if (StringUtils.isEmpty((CharSequence)String.valueOf(message.getDelaySendTime()))) {
                message.setDelaySendTime(0);
            }
            JdbcTemplate jdbcTemplate = this.createNewJdbcTemplate();
            String sql = "insert into mqsendrecord(messageId,subject,tag,content,queueName,delaySendTime,createTime,status) values('" + message.getMessageId() + "','" + message.getSubject() + "','" + message.getTag() + "','" + message.getContent() + "','" + message.getQueueName() + "','" + message.getDelaySendTime() + "','" + LocalDateTime.now().toString() + "'," + message.getStatus() + ");";
            for (String s : sqls = sql.split(";")) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                jdbcTemplate.execute(s);
            }
        }
    }

    public void updateMqRecord(ProxyMessage message) {
        if ("true".equals(this.apolloConfigVO.getDataSourceEnable())) {
            String[] sqls;
            if (StringUtils.isEmpty((CharSequence)message.getMessageId())) {
                throw new ZTBusinessException("*********\u6d88\u606fid\u4e0d\u80fd\u4e3a\u7a7a**********");
            }
            JdbcTemplate jdbcTemplate = this.createNewJdbcTemplate();
            String sql = "update mqsendrecord set status = " + message.getStatus() + ",updateTime = '" + LocalDateTime.now().toString() + "' where messageId = '" + message.getMessageId() + "';";
            for (String s : sqls = sql.split(";")) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                jdbcTemplate.execute(s);
            }
        }
    }

    public void thread(final ProxyMessage message, final MqRecordLog mqRecordLog) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                mqRecordLog.updateMqRecord(message);
            }
        };
        ExecutorProcessPool.getInstance().executeByCustomThread(runnable);
    }

    public JdbcTemplate createNewJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            DruidDataSource datasource = new DruidDataSource();
            datasource.setDriverClassName(this.apolloConfigVO.getDriverClassName());
            datasource.setUrl(this.apolloConfigVO.getDataSourceUrl());
            datasource.setUsername(this.apolloConfigVO.getUserName());
            datasource.setPassword(this.apolloConfigVO.getPassword());
            return new JdbcTemplate((DataSource)datasource);
        }
        return this.jdbcTemplate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.apolloConfigVO = (ApolloConfigVO)applicationContext.getBean(ApolloConfigVO.class);
    }
}

