/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.tonglkq;

import com.ohaotian.license.verify.service.LicenseVerifyService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageException;
import com.tongtech.tmqi.QueueConnectionFactory;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;

public class TongLKQMessageSender
implements ProxyMessageProducerEx,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(TongLKQMessageSender.class);
    private LicenseVerifyService licenseVerifyService;
    private Environment environment;
    private final Map<ProxyMessageType, Set<String>> typeTagsMapping;
    private ProxyMessageConfig messageConfig;
    private final String subject;
    QueueConnection queueConnection;
    QueueSession queueSession;
    QueueSender queueSender;

    public TongLKQMessageSender(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        log.info("[" + this.getClass().getName() + "] required properties[mq.endpoint]");
        this.subject = messageConfig.getSubject();
        this.messageConfig = messageConfig;
        this.typeTagsMapping = typeTagsMapping;
    }

    @Override
    public void startup() {
        log.debug("\u5f00\u59cb\u521b\u5efa\u751f\u4ea7\u8005\u5bf9\u8c61bean");
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String tlqUrl = this.environment.getProperty("mq.endpoint");
        try {
            QueueConnectionFactory queueConnectionFactory = new QueueConnectionFactory();
            queueConnectionFactory.setProperty("tmqiAddressList", tlqUrl);
            this.queueConnection = queueConnectionFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            this.queueConnection.start();
        }
        catch (Exception jmsEx) {
            if (this.queueSession != null) {
                try {
                    this.queueSession.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            if (this.queueConnection != null) {
                try {
                    this.queueConnection.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            log.error("Exception occurred :" + jmsEx.toString());
            jmsEx.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.queueSession != null) {
                this.queueSession.close();
            }
            if (this.queueConnection != null) {
                this.queueConnection.close();
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ProxySendResult send(ProxyMessage message) {
        ProxySendResult proxySendResult;
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        try {
            TextMessage sendMessage = this.queueSession.createTextMessage(message.getContent());
            if (sendMessage != null) {
                Queue queue = this.queueSession.createQueue(message.getSubject());
                this.queueSender = this.queueSession.createSender(queue);
                this.queueSender.send((Message)sendMessage);
                proxySendResult = this.getProxySendResult(true);
            } else {
                proxySendResult = this.getProxySendResult(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
        return proxySendResult;
    }

    private ProxySendResult getProxySendResult(boolean send) {
        ProxySendResult proxySendResult = new ProxySendResult();
        if (send) {
            proxySendResult.setStatus("SEND_OK");
        } else {
            proxySendResult.setStatus("SEND_FAIL");
        }
        return proxySendResult;
    }

    @Override
    public void send(ProxyMessage message, ProxySendCallback sendCallback) {
        log.error("tlq not support");
    }

    @Override
    public void sendOneway(ProxyMessage message) {
        log.error("tlq not support");
    }

    @Override
    public ProxySendResult sendInTransaction(ProxyMessage proxyMessage, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        log.error("tlq not support");
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.licenseVerifyService = (LicenseVerifyService)applicationContext.getBean(LicenseVerifyService.class);
        this.environment = applicationContext.getEnvironment();
    }
}

