/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ext.ExtInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class MQUtils {
    private static final Map<String, ExtInfo> EXT_INFO_MAPPING;

    public static Map<String, ExtInfo> getExtInfoMapping() {
        return EXT_INFO_MAPPING;
    }

    public static String tags2Line(Set<String> tagSet) {
        StringBuilder tagLine = new StringBuilder();
        String seprator = null;
        for (String tag : tagSet) {
            if (seprator != null) {
                tagLine.append(seprator);
            } else {
                seprator = "||";
            }
            tagLine.append(tag);
        }
        return tagLine.toString();
    }

    static {
        Properties props = new Properties();
        try {
            HashMap<String, ExtInfo> extInfoMapping = new HashMap<String, ExtInfo>();
            props.setProperty("RocketMQ.register", "com.ohaotian.plugin.mq.proxy.ext.rocketmq.RocketMQMessageConsumerRegister");
            props.setProperty("RocketMQ.sender", "com.ohaotian.plugin.mq.proxy.ext.rocketmq.RocketMqMessageSender");
            props.setProperty("RedisMQ.register", "com.ohaotian.plugin.mq.proxy.ext.redismq.RedisMQMessageConsumerRegister");
            props.setProperty("RedisMQ.sender", "com.ohaotian.plugin.mq.proxy.ext.redismq.RedisMqMessageSender");
            props.setProperty("AliyunMQ.register", "com.ohaotian.plugin.mq.proxy.ext.aliyunmq.AliyunMQMessageConsumerRegister");
            props.setProperty("AliyunMQ.sender", "com.ohaotian.plugin.mq.proxy.ext.aliyunmq.AliyunMqMessageSender");
            props.setProperty("DefaultMQ.register", "com.ohaotian.plugin.mq.proxy.ext.defaultmq.DefaultMqMessageConsumerRegister");
            props.setProperty("DefaultMQ.sender", "com.ohaotian.plugin.mq.proxy.ext.defaultmq.DefaultMqMessageSender");
            props.setProperty("SofaMQ.register", "com.ohaotian.plugin.mq.proxy.ext.sofamq.SofaMqMessageConsumerRegister");
            props.setProperty("SofaMQ.sender", "com.ohaotian.plugin.mq.proxy.ext.sofamq.SofaMqMessageSender");
            props.setProperty("RabbitMQ.register", "com.ohaotian.plugin.mq.proxy.ext.rabbitmq.RabbitMQMessageConsumerRegister");
            props.setProperty("RabbitMQ.sender", "com.ohaotian.plugin.mq.proxy.ext.rabbitmq.RabbitMqMessageSender");
            props.setProperty("TongLKQ.register", "com.ohaotian.plugin.mq.proxy.ext.tonglkq.TongLKQMessageConsumerRegister");
            props.setProperty("TongLKQ.sender", "com.ohaotian.plugin.mq.proxy.ext.tonglkq.TongLKQMessageSender");
            Set<Object> keySet = props.keySet();
            for (Object keyObj : keySet) {
                String key = (String)keyObj;
                if (extInfoMapping.containsKey(key = key.substring(0, key.indexOf(".")))) continue;
                extInfoMapping.put(key, new ExtInfo());
            }
            Set entrySet = extInfoMapping.entrySet();
            for (Map.Entry entry : entrySet) {
                ExtInfo extInfo = (ExtInfo)entry.getValue();
                extInfo.setRegisterClass(Class.forName(props.getProperty((String)entry.getKey() + ".register")));
                if (!extInfo.registerSupported((String)entry.getKey())) {
                    throw new IllegalStateException("handler[" + extInfo.getRegisterClass().getName() + "] key must be [" + (String)entry.getKey() + ".register]");
                }
                extInfo.setSenderClass(Class.forName(props.getProperty((String)entry.getKey() + ".sender")));
            }
            EXT_INFO_MAPPING = Collections.unmodifiableMap(extInfoMapping);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("init mq-proxy handlers error", e);
        }
    }
}

