/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.sofamq;

import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.ext.sofamq.SofaMqMessageListener;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.ohaotian.plugin.mq.proxy.impl.MQUtils;
import io.openmessaging.api.Consumer;
import io.openmessaging.api.Message;
import io.openmessaging.api.MessageListener;
import io.openmessaging.api.OMS;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class SofaMqMessageConsumerRegister
implements MQRegister,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SofaMqMessageConsumerRegister.class);
    private Consumer consumer;
    private boolean started;
    private MqRecordLog mqRecordLog;
    private Environment environment;

    @Override
    public void register(ConsumerRegisterInfo consumerInfo, ApolloConfigVO apolloConfigVO) {
        ProxyMessageType[] messageTypes;
        String subject = consumerInfo.getSubject();
        for (ProxyMessageType messageType : messageTypes = consumerInfo.getMessageTypes()) {
            if (this.supportConcurrently(messageType)) continue;
            throw new UnsupportedOperationException("unsupported messageType[" + (Object)((Object)messageType) + "] for subject[" + consumerInfo.getSubject() + "]");
        }
        Properties config = new Properties();
        config.put("accessKey", this.environment.getProperty("mq.accessKey"));
        config.put("secretKey", this.environment.getProperty("mq.secretKey"));
        config.put("endpoint", this.environment.getProperty("mq.endpoint"));
        config.put("instanceId", this.environment.getProperty("mq.instanceId"));
        config.put("dataCenter", this.environment.getProperty("mq.dataCenter"));
        String consumeThreadNums = "mq." + consumerInfo.getCid() + ".consumeThreadNums";
        if (!StringUtils.isEmpty((Object)this.environment.getProperty(consumeThreadNums))) {
            config.put("consumeThreadNums", this.environment.getProperty(consumeThreadNums));
            log.info("register " + consumeThreadNums + " success!!");
        }
        if (!StringUtils.isEmpty((Object)consumerInfo.getCid())) {
            config.put("groupId", consumerInfo.getCid());
        }
        this.consumer = OMS.builder().driver("sofamq").build(config).createConsumer(config);
        this.consumer.subscribe(subject, MQUtils.tags2Line(consumerInfo.getTags()), (MessageListener)new SofaMqMessageListener(consumerInfo.getConsumerWrappers(), this.mqRecordLog));
        log.info("register sofa consumer success!!");
    }

    @Override
    public boolean support(String strategy) {
        return Strategy.isSofaMQ(strategy);
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isSofaMQ(strategy);
    }

    @Override
    public void startup() {
        if (this.started) {
            return;
        }
        this.consumer.start();
        this.started = true;
    }

    @Override
    public void shutdown() {
        if (!this.started) {
            return;
        }
        this.consumer.shutdown();
        this.started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.mqRecordLog = (MqRecordLog)applicationContext.getBean(MqRecordLog.class);
        this.environment = applicationContext.getEnvironment();
    }

    protected static ProxyMessage getMessage(Message sofaMessage) {
        ProxyMessage message;
        try {
            message = new ProxyMessage(sofaMessage.getTopic(), sofaMessage.getTag(), new String(sofaMessage.getBody(), "UTF-8"));
            message.setMessageId(sofaMessage.getMsgID());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("sofaMessage 2 ProxyMessage Error", e);
        }
        return message;
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }
}

