/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.sofamq;

import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ext.sofamq.SofaMqMessageConsumerRegister;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import io.openmessaging.api.Action;
import io.openmessaging.api.ConsumeContext;
import io.openmessaging.api.Message;
import io.openmessaging.api.MessageListener;
import java.util.Set;

public class SofaMqMessageListener
implements MessageListener {
    private final Set<IProxyMessageConsumerWrapper> localConsumers;
    private MqRecordLog mqRecordLog;

    public SofaMqMessageListener(Set<IProxyMessageConsumerWrapper> localConsumers, MqRecordLog mqRecordLog) {
        this.mqRecordLog = mqRecordLog;
        this.localConsumers = localConsumers;
    }

    public Action consume(Message message, ConsumeContext consumeContext) {
        this.processMessage(message, this.localConsumers);
        return Action.CommitMessage;
    }

    private void processMessage(Message sofaMessage, Set<IProxyMessageConsumerWrapper> localConsumers) {
        ProxyMessage message = SofaMqMessageConsumerRegister.getMessage(sofaMessage);
        try {
            for (ProxyMessageConsumer proxyMessageConsumer : localConsumers) {
                proxyMessageConsumer.onMessage(message);
            }
            message.setStatus(2);
        }
        catch (RuntimeException e) {
            message.setStatus(3);
            throw new RuntimeException(e);
        }
        finally {
            this.mqRecordLog.thread(message, this.mqRecordLog);
        }
    }

    public String toString() {
        return "SofaMQMessageListener";
    }
}

