/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.aliyunmq;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ext.aliyunmq.AliyunMQMessageConsumerRegister;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import java.util.Set;

public class AliyunMessageListener
implements MessageListener {
    private final Set<IProxyMessageConsumerWrapper> localConsumers;
    private MqRecordLog mqRecordLog;

    AliyunMessageListener(Set<IProxyMessageConsumerWrapper> localConsumers, MqRecordLog mqRecordLog) {
        this.mqRecordLog = mqRecordLog;
        this.localConsumers = localConsumers;
    }

    public Action consume(Message message, ConsumeContext consumeContext) {
        this.processMessage(message, this.localConsumers);
        return Action.CommitMessage;
    }

    public String toString() {
        return "AliyunMessageListener";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this.toString().equals(obj.toString());
    }

    private void processMessage(Message aliyunMessage, Set<IProxyMessageConsumerWrapper> localConsumers) {
        ProxyMessage message = AliyunMQMessageConsumerRegister.getMessage(aliyunMessage);
        try {
            for (ProxyMessageConsumer proxyMessageConsumer : localConsumers) {
                proxyMessageConsumer.onMessage(message);
            }
            message.setStatus(2);
            this.mqRecordLog.thread(message, this.mqRecordLog);
        }
        catch (RuntimeException e) {
            message.setStatus(3);
            this.mqRecordLog.thread(message, this.mqRecordLog);
            throw new RuntimeException(e);
        }
    }
}

