/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.tonglkq;

import com.ohaotian.plugin.mq.proxy.MqRecordLog;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ext.tonglkq.TLQMessageListener;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueReceiver;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TongLKQMqMessageListener
implements TLQMessageListener,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(TongLKQMqMessageListener.class);
    private final Set<IProxyMessageConsumerWrapper> localConsumers;
    private MqRecordLog mqRecordLog;
    private final QueueReceiver queueReceiver;
    private final String subject;
    private volatile boolean running = true;

    public TongLKQMqMessageListener(String subject, Set<IProxyMessageConsumerWrapper> localConsumers, MqRecordLog mqRecordLog, QueueReceiver queueReceiver) {
        this.mqRecordLog = mqRecordLog;
        this.localConsumers = localConsumers;
        this.queueReceiver = queueReceiver;
        this.subject = subject;
    }

    @Override
    public ProxyConsumerStatus onMessage(QueueReceiver queueReceiver, Set<IProxyMessageConsumerWrapper> localConsumers) {
        ProxyMessage proxyMessage = new ProxyMessage();
        try {
            Message message = queueReceiver.receive(6000L);
            if (message != null && message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                proxyMessage = new ProxyMessage(this.subject, "*", textMessage.getText());
                for (ProxyMessageConsumer proxyMessageConsumer : localConsumers) {
                    proxyMessageConsumer.onMessage(proxyMessage);
                }
                proxyMessage.setStatus(2);
                this.mqRecordLog.thread(proxyMessage, this.mqRecordLog);
            }
        }
        catch (JMSException e) {
            proxyMessage.setStatus(3);
            this.mqRecordLog.thread(proxyMessage, this.mqRecordLog);
            e.printStackTrace();
            this.running = Boolean.FALSE;
        }
        return null;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.onMessage(this.queueReceiver, this.localConsumers);
            }
            catch (Exception e) {
                log.error("Unexpected error in message listener", (Throwable)e);
                this.running = Boolean.FALSE;
            }
        }
    }

    public String toString() {
        return "TongLKQMqMessageListener";
    }
}

