package com.ohaotian.plugin.mq.proxy.constants;

import com.ohaotian.plugin.mq.proxy.RedisCacheStore;
import com.ohaotian.plugin.mq.proxy.impl.ProxyMessageRegister;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import org.springframework.util.StringUtils;

/**
 * 标题：消息配置工具类
 * <p>
 * 说明：消息配置工具类
 * <br>
 * 时间：2018/07/25<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author ZhangCheng
 */
public class MessageConfigUtils {

    public static final String DEFAULT_PRODUCER_ID = "DEFAULT_PRODUCER_ID";

    /**
     * 判断是否禁用插件
     * @param enable 是否启用
     * @return true:禁用；false:启用
     */
    public static Boolean isDisable(String enable) {
        if (StringUtils.isEmpty(enable)){
            return true;
        }
        if (Boolean.TRUE.toString().equals(enable.toLowerCase())){
            return false;
        }else if (Boolean.FALSE.toString().equals(enable.toLowerCase())){
            return true;
        }else {
            throw new IllegalArgumentException(LogUtils.PLUGIN_NAME+"["+Keys.Mq.ENABLE+"] 只能设置为 [true] 或 [false]，请检查配置文件！");
        }
    }

    /**
     * 消息配置 Fields
     * 内部使用
     */
    public class Fields {
        /**
         * 配置类
         */
        public static final String MESSAGE_CONFIG = "messageConfig";
        /**
         * 是否启用
         */
        public static final String ENABLE = "enable";
        /**
         * 消息策略
         */
        public static final String STRATEGY = "strategy";
        /**
         * 消费者或生产者ID
         */
        public static final String ID = "id";
        /**
         * 主题
         */
        public static final String SUBJECT = "subject";
        /**
         * 标签
         */
        public static final String TAGS = "tags";
        /**
         * 队列名称
         */
        public static final String QUEUENAME = "queueName";
    }

    public static String getElKeyByKey(String key) {
        if (StringUtils.isEmpty(key)) {
            return key;
        }
        return "${" + key + "}";
    }

    /**
     * 消息配置 Keys 与 配置文件中的 key 一致（如：default.properties）
     * 外部使用
     */
    public class Keys {
        /**
         * MQ 配置子项
         */
        public class Mq {
            /**
             * 是否启用插件（true：启用；false：不启用；缺省值：false）
             */
            public static final String ENABLE = "mq.enable";
            /**
             * 消息策略
             */
            public static final String STRATEGY = "mq.strategy";
        }

        /**
         * AliyunMQ 配置
         */
        public class Aliyun {
            /**
             * 授权Key
             */
            public static final String ACCESS_KEY = "mq.accessKey";
            /**
             * 安全Key
             */
            public static final String SECRET_KEY = "mq.secretKey";
            /**
             * Aliyun 地址
             */
            public static final String ONS_ADDR = "mq.onsAddr";
            /**
             * 消息发送超时时间（单位：毫秒）
             */
            public static final String SEND_MSG_TIMEOUT_MILLIS = "mq.sendMsgTimeoutMillis";
        }

        /**
         * RocketMQ 配置
         */
        public class Rocket {
            /**
             * Rocket地址
             */
            public static final String NAMESRVADDR = "mq.rocket.namesrvaddr";
        }

        /**
         * RedisMQ 配置
         */
        public class Redis {
            /**
             * Redis地址
             */
            public static final String URL = "mq.redis.url";
        }

        public class RabbitMQ{
            public static final String EXCHANGENAME = "mq.exchangeName";
            public static final String QUEUENAME = "mq.queueName";
        }
    }

    /**
     * 插件相关类在Spring注册时Bean名称
     */
    public class BeanNames {
        /**
         * 注册机的名称
         *
         * @see ProxyMessageRegister
         */
        public static final String PROXY_MESSAGE_REGISTER = "proxyMessageRegister";
        /**
         * Redis缓存的名称
         *
         * @see RedisCacheStore
         */
        public static final String REDIS_CACHE_STORE = "redisCacheStore";
        /**
         * 生产者的名称
         *
         * @see ProxyProducerFactoryBean
         */
        public static final String PRODUCER = "producer";
    }
}
