package com.ohaotian.plugin.mq.proxy.ext.rocketmq;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.ohaotian.plugin.mq.proxy.impl.MQUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class RocketMQMessageConsumerRegister implements MQRegister, ApplicationContextAware {
    private Properties mergedProps = new Properties();
    //@ApolloConfig
    //private Config apolloConfig= ConfigService.getConfig("TEST1.application-${env}");
    private String defaultValue = "defaultValue";
    private boolean started;
    private DefaultMQPushConsumer consumer;
    @Autowired
    private ApolloConfigVO apolloConfigVO;
    @Autowired
    private ApplicationContext applicationContext;
    public void register(ConsumerRegisterInfo consumerInfo,ApolloConfigVO apolloConfigVO) {
        String subject = consumerInfo.getSubject();
        ProxyMessageType[] messageTypes = consumerInfo.getMessageTypes();
        for (ProxyMessageType messageType : messageTypes) {
            if (supportConcurrently(messageType)) {
                continue;
            }
            throw new UnsupportedOperationException("Unsuppoorted messageType[" + messageType + "] for subject[" + consumerInfo.getSubject() + "]");
        }

        consumer = new DefaultMQPushConsumer(consumerInfo.getCid());
        consumer.setNamesrvAddr(consumerInfo.getProperties().getProperty("mq.rocket.namesrvaddr", apolloConfigVO.getRocketNamesrvaddr()));
        try {
            consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
            consumer.subscribe(subject, MQUtils.tags2Line(consumerInfo.getTags()));
            consumer.setInstanceName(UUID.randomUUID().toString());
        } catch (MQClientException e) {
            throw new IllegalStateException("Consumer[" + consumerInfo.getSubject() + "] subscribe error", e);
        }
        consumer.registerMessageListener((MessageListenerConcurrently) new RocketMQMessageListener(consumerInfo.getConsumerWrappers()));
        consumer.registerMessageListener((MessageListenerOrderly) new RocketMQMessageListener(consumerInfo.getConsumerWrappers()));
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    protected static ProxyMessage getMessage(MessageExt messageExt) {
        ProxyMessage message;
        try {
            message = new ProxyMessage(messageExt.getTopic(), messageExt.getTags(), new String(messageExt.getBody(), RemotingHelper.DEFAULT_CHARSET));
            message.setMessageId(messageExt.getMsgId());
        } catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("MessageExt 2 ProxyMessage Error", e);
        }
        return message;
    }

    public boolean support(String strategy) {
        return RocketMQMessageConsumerRegister.strategySupported(strategy);
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isRocketMQ(strategy);
    }

    public void startup() {
        if (started) {
            return;
        }
        try {
            consumer.start();
        } catch (MQClientException e) {
            throw new IllegalStateException("Start MQConsumer error", e);
        }
        started = true;
    }

    public void shutdown() {
        if (!started) {
            return;
        }
        consumer.shutdown();
        started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, Properties> propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap(props, mergedProps);
            }
        }
    }
}
