/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.ohaotian.plugin.cache.CacheService;
import com.ohaotian.plugin.mq.NativeTransOnsProductor;
import com.ohaotian.plugin.mq.bo.MqProduceSingleBO;
import com.ohaotian.plugin.mq.interfce.MqProduceService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MqTranProducerPool
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MqTranProducerPool.class);
    private Map<String, TransactionProducer> producers = new HashMap<String, TransactionProducer>();
    private LocalTransactionChecker localTransactionChecker;
    private Properties propertyConfigurer;
    private boolean nativeOns = false;
    ApplicationContext applicationContext;
    private CacheService cacheService;
    private Map<String, Properties> producerProperties = new HashMap<String, Properties>();

    public void setLocalTransactionChecker(LocalTransactionChecker localTransactionChecker) {
        this.localTransactionChecker = localTransactionChecker;
    }

    public void setPropertyConfigurer(Properties propertyConfigurer) {
        this.propertyConfigurer = propertyConfigurer;
    }

    public Properties getPropertyConfigurer() {
        return this.propertyConfigurer;
    }

    public boolean isNativeOns() {
        return this.nativeOns;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void init() {
        String accessKey = this.propertyConfigurer.getProperty("ons.AccessKey");
        String secretKey = this.propertyConfigurer.getProperty("ons.SecretKey");
        String namesrvAddr = this.propertyConfigurer.getProperty("mq.NAMESRV_ADDR");
        String oNSAddr = this.propertyConfigurer.getProperty("mq.ONSAddr");
        this.nativeOns = Boolean.parseBoolean(this.propertyConfigurer.getProperty("ons.native"));
        Map mqMap = this.applicationContext.getBeansOfType(MqProduceService.class);
        HashMap<String, MqProduceSingleBO> proMap = new HashMap<String, MqProduceSingleBO>();
        for (String key : mqMap.keySet()) {
            MqProduceService mqc = (MqProduceService)mqMap.get(key);
            List<MqProduceSingleBO> msList = mqc.producer();
            if (msList == null) continue;
            for (MqProduceSingleBO ms : msList) {
                proMap.put(ms.getTopic(), ms);
            }
        }
        for (String key : proMap.keySet()) {
            MqProduceSingleBO mbo = (MqProduceSingleBO)proMap.get(key);
            String topic = this.propertyConfigurer.getProperty(mbo.getTopic());
            if (StringUtils.isNotBlank((CharSequence)topic)) {
                topic = topic.trim();
            } else {
                log.error("topic\u548cpic\u7684\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u53c2\u7167\u5176\u4ed6\u6d88\u606f\u914d\u7f6e\uff01{PID:" + mbo.getPid() + ",TOPIC:" + mbo.getTopic() + "}");
            }
            NativeTransOnsProductor producer = null;
            if (this.nativeOns) {
                producer = new NativeTransOnsProductor(this.cacheService);
                producer.start();
            } else {
                String pid = this.propertyConfigurer.getProperty(mbo.getPid());
                if (StringUtils.isNotBlank((CharSequence)pid)) {
                    pid = pid.trim();
                } else {
                    log.error("topic\u548cpic\u7684\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u53c2\u7167\u5176\u4ed6\u6d88\u606f\u914d\u7f6e\uff01{PID:" + mbo.getPid() + ",TOPIC:" + mbo.getTopic() + "}");
                }
                Properties properties = new Properties();
                properties.put("ProducerId", pid);
                if (StringUtils.isNotBlank((CharSequence)accessKey)) {
                    properties.put("AccessKey", accessKey);
                }
                if (StringUtils.isNotBlank((CharSequence)secretKey)) {
                    properties.put("SecretKey", secretKey);
                }
                if (StringUtils.isNotBlank((CharSequence)namesrvAddr)) {
                    properties.put("NAMESRV_ADDR", namesrvAddr);
                }
                if (StringUtils.isNotBlank((CharSequence)oNSAddr)) {
                    properties.put("ONSAddr", oNSAddr);
                }
                producer = ONSFactory.createTransactionProducer((Properties)properties, (LocalTransactionChecker)this.localTransactionChecker);
                producer.start();
                this.producerProperties.put(topic, properties);
            }
            this.producers.put(topic, producer);
        }
    }

    public TransactionProducer getTransactionProducer(String topic) {
        TransactionProducer tp = this.producers.get(topic);
        return tp;
    }

    public synchronized TransactionProducer getSynTransactionProducer(String topic) {
        TransactionProducer tp = this.producers.get(topic);
        if (tp == null) {
            Properties properties = this.producerProperties.get(topic);
            tp = ONSFactory.createTransactionProducer((Properties)properties, (LocalTransactionChecker)this.localTransactionChecker);
            tp.start();
            this.producers.put(topic, tp);
        }
        return tp;
    }
}

