package com.ohaotian.plugin.uuid.mq;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ohaotian.plugin.uuid.cache.CacheClient;
import com.ohaotian.plugin.uuid.common.util.SerializeUtils;
import com.ohaotian.plugin.uuid.mq.bo.MqConstants;
import com.ohaotian.plugin.uuid.mq.interfce.MqCunsumer;
import com.ohaotian.plugin.uuid.mq.bo.MessageInfoBO;
import com.ohaotian.plugin.uuid.mq.exception.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/** <br>
 * 标题: <br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho liuce
 * @time 2016年9月25日 下午3:02:38 */
public class NativeMqListener extends Thread {

	private static final Logger           log          = LoggerFactory.getLogger(NativeMqListener.class);

	/** 本地模式topic和消费者 */
	public static Map<String, List<MqCunsumer>> nativeTopics = null;

	/** 缓存service 用来作为本地模式存放的队列 */
	public CacheClient cacheService;

	/** <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param cacheService
	 * @autho liuce
	 * @time 2016年9月25日 下午3:07:22 */
	public NativeMqListener(CacheClient cacheService) {
		super();
		this.cacheService = cacheService;
	}

	@Override
	public void run() {
		while (true) {
			try {
				doBusi();
			}
			catch (Exception e) {
				log.error("本地消费者模式下出现异常了！请检查错误！", e);
			}

			try {
				Thread.sleep(600);
			}
			catch (InterruptedException e) {
				log.error("线程sleep异常！", e);
			}
		}
	}

	private void doBusi() {
		// 获取缓存中所有的消息
		Set<String> keys = cacheService.getkeys("LOCALMQ_*");
		// 遍历所有的key获取消息内容
		for (String key : keys) {
			MessageInfoBO msgbo = cacheService.get(key, MessageInfoBO.class);
			// 如果消息消费状态为null说明没有消费。
			if (msgbo != null && msgbo.getConsumerStatus() == null) {
				// 设置消费者状态为进行中
				msgbo.setConsumerStatus(MqConstants.CONSUMER_STATUS_UPDATE);
				cacheService.put(key, msgbo);
				String topic = msgbo.getTopic();
				if (nativeTopics == null) {
					nativeTopics = MqCunsumerSubscribe.nativeTopics;
				}
				List<MqCunsumer> mqcList = nativeTopics.get(topic);
				// 消费者不存在本中心或者还没有注册完成，将消息的消费者状态改为null
				if (mqcList == null) {
					// 设置消费者状态为未消费
					msgbo.setConsumerStatus(null);
					cacheService.put(key, msgbo);
					continue;
				}
				else {
					try {
						//循环判断相等的tag
						for(MqCunsumer mqc:mqcList){
							if("*".equals(mqc.subscribe().getTag())){
								mqc.execute(msgbo.getTag(), SerializeUtils.deserialize(msgbo.getBody()));
							}
							if(msgbo.getTag().equals(mqc.subscribe().getTag())){
								mqc.execute(msgbo.getTag(), SerializeUtils.deserialize(msgbo.getBody()));
							}
						}
					}
					catch (ResourceException e) {
						// 业务执行失败
						log.error("业务执行失败！消息消费失败！请检查错误", e);
						continue;
					}
					catch (Exception e) {
						// 消息消费失败失败
						log.error("系统异常!消息消费失败！请检查错误", e);
						continue;
					}
					finally {
						// 直接删除消费失败的信息
						cacheService.delete(key);
					}
				}
			}
		}
	}

}
