package com.ohaotian.plugin.uuid.mq;

import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

import com.ohaotian.plugin.uuid.cache.CacheClient;
import com.ohaotian.plugin.uuid.mq.bo.MessageInfoBO;
import com.ohaotian.plugin.uuid.mq.bo.MqConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;

public class NativeOnsProductor implements Producer {
	private final static Logger log            = LoggerFactory.getLogger(NativeOnsProductor.class);
	/** <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 *
	 * @param cacheService
	 * @autho liuce
	 * @time 2016年9月25日 下午2:45:31 */
	public NativeOnsProductor(CacheClient cacheService) {
		this.cacheService = cacheService;
	}

	/** 缓存service 用来作为本地模式存放的队列 */
	private CacheClient cacheService;

	private boolean      isStarted;

	@Override
	public boolean isStarted() {
		return isStarted;
	}

	@Override
	public boolean isClosed() {
		return !isStarted();
	}

	@Override
	public void start() {
		this.isStarted = true;
	}

	@Override
	public void updateCredential(Properties properties) {

	}

	@Override
	public void shutdown() {
		this.isStarted = false;
	}

	@Override
	public SendResult send(Message message) {
		SendResult sendResult = new SendResult();
		String msgid = "NAV-" + System.nanoTime();
		sendResult.setMessageId(msgid);
		MessageInfoBO msgbo = new MessageInfoBO();

		msgbo.setBody(message.getBody());
		msgbo.setMsgId(msgid);
		msgbo.setTag(message.getTag());
		msgbo.setTopic(message.getTopic());
		msgbo.setMsgKey(message.getKey());
		msgbo.setSendStatus(MqConstants.PRODUCT_SEND_STATUS_SUCCESS);
		msgbo.setSendTime(new Date());
		cacheService.put("LOCALMQ_" + msgid, msgbo);
		log.debug("LOCALMQ_" + msgid, msgbo);

		return sendResult;
	}

	@Override
	public void sendOneway(Message message) {
		throw new UnsupportedOperationException("NativeOnsProductor not support sendOneway");
	}

	@Override
    public void sendAsync(Message message, SendCallback sendCallback) {

    }

	@Override
	public void setCallbackExecutor(ExecutorService executorService) {

	}
}