package com.ohaotian.plugin.uuid.mq;

import java.util.Date;

import com.aliyun.openservices.ons.api.Message;
import com.ohaotian.plugin.uuid.mq.bo.MessageInfoBO;
import com.ohaotian.plugin.uuid.mq.bo.MqConstants;

public class OnsUtils {

	/** 根据发送对象转化为数据数据库记录对象。
	 * 
	 * @param msg
	 * @param msgId
	 * @param debug
	 * @return */
	public static MessageInfoBO saveMessageInfo(Message msg, String msgId, String debug) {
		/* 记录发送信息及其发送内容 */
		MessageInfoBO mi = new MessageInfoBO();
		mi.setMsgId(msgId);
		mi.setTopic(msg.getTopic());
		mi.setTag(msg.getTag());
		mi.setMsgKey(msg.getKey());
//		mi.setBody(msg.getBody());
		mi.setSendStatus(MqConstants.PRODUCT_SEND_STATUS_SUCCESS);
		mi.setSendTime(new Date());
		return mi;
	}
}
