package com.ohaotian.plugin.uuid.mq.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

/** <br>
 * 标题: <br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho liuce
 * @time 2017年5月4日 下午4:31:49 */
public class ThrowableInfoUtils {

	/** @Description:将Throwable对象的错误堆栈内容形成字符串<br> 参考 {@link org.apache.log4j.spi.ThrowableInformation} 代码
	 * @param throwable
	 *        异常对象
	 * @return
	 * @author mahh
	 * @since：2014-9-30 下午02:32:51 */
	public static String getThrowableStrRep(Throwable throwable) {
		if (throwable == null) {
			return null;
		}

		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		throwable.printStackTrace(pw);
		pw.flush();
		LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));

		StringBuffer sb = new StringBuffer();

		try {
			String line = reader.readLine();
			while (line != null) {
				sb.append(line);
				line = reader.readLine();
			}
		}
		catch (IOException ex) {
			sb.append(ex.toString());
		}
		return sb.toString();
	}
}
