package com.ohaotian.plugin.mq.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** <br>
 * 标题: mq配置文件维护<br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho liuce
 * @time 2016年8月26日 下午4:32:17 */
@SuppressWarnings("unchecked")
public class XmlManageDom4jUtils {

	private static final Logger log = LoggerFactory.getLogger(XmlManageDom4jUtils.class);

	/** 将mq的配置文件从ons替换为rocketmq 或者将rocketmq的配置文件替换为ons的 <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param a
	 * @param b
	 * @autho liuce
	 * @time 2016年8月27日 下午2:52:12 */
	public static void changeMqXmlFromAToB(String a, String b) {
		String path = System.getProperty("user.dir").replace("\\", "/") + "/src/main/resources/spring";
		File file = new File(path);
		File[] tempList = file.listFiles();
		if (tempList != null) {
			for (File f : tempList) {
				if (f.getName().contains("-" + a + "-")) {
					String newPath = f.getPath().replace("-" + a + "-", "-" + b + "-");
					try {
						changeMQXml(f.getPath(), newPath);
					}
					catch (Exception e) {
						log.error("转换生产者出错！请检查配置文件【" + f.getPath() + "】", e);
					}
				}
			}
		}
	}

	/** 根据service将xml配置文件转化为hsf提供者和hsf消费者 <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @autho liuce
	 * @time 2016年8月27日 下午4:37:39 */
	public static void transformationServiceXmlToHsf() {
		String basePath = System.getProperty("user.dir").replace("\\", "/");
		String path = basePath + "/src/main/resources/spring";
		File file = new File(path);
		File[] tempList = file.listFiles();
		InputStream ins = null;
		Properties props = new Properties();
		try {
			ins = XmlManageDom4jUtils.class.getClassLoader().getResourceAsStream("env.properties");
			props.load(ins);
		}
		catch (IOException e) {
			throw new RuntimeException("加载env.properties出错", e);
		}
		finally {
			if (ins != null) {
				try {
					ins.close();
				}
				catch (IOException e) {
					log.error(e.getMessage(), e);
				}
			}
		}
		String[] saleInterfaces = props.getProperty("sale.interface", "").split(",");
		Set<String> saleInterfaceSet = new HashSet<String>(saleInterfaces.length);
		boolean openMqCunsumer = Boolean.parseBoolean(props.getProperty("mq.cunsumer.switch", "false").trim());
		for (String saleInterface : saleInterfaces) {
			saleInterfaceSet.add(saleInterface);
		}

		// 添加特殊消费者端的的hsf配置，例如添加connectionNum的配置
		String[] chsfEspecialConfigs = props.getProperty("chsf_especial_config", "").split(",");
		Map<String, Set<String>> chsfEspecialConfigMap = new HashMap<String, Set<String>>(chsfEspecialConfigs.length);
		for (String chsfEspecialConfig : chsfEspecialConfigs) {
			String[] values = chsfEspecialConfig.split(":");

			if (values.length != 2) {
				log.error("hsf特殊的配置文件有问题，请检查配置文件【env.properties】中的hsf_especial_config");
				continue;
			}
			String[] configs = values[1].split(",");
			Set<String> configsSet = new HashSet<String>(configs.length);
			for (String config : configs) {
				configsSet.add(config);
			}

			chsfEspecialConfigMap.put(values[0], configsSet);
		}

		// 添加特殊服务提供者端的的hsf配置，例如添加methodSpecials的配置
		String[] phsfEspecialConfigs = props.getProperty("phsf_especial_config", "").split(",");
		Map<String, Set<String>> phsfEspecialConfigMap = new HashMap<String, Set<String>>(phsfEspecialConfigs.length);
		for (String phsfEspecialConfig : phsfEspecialConfigs) {
			String[] values = phsfEspecialConfig.split(":");

			if (values.length != 2) {
				log.error("hsf特殊的配置文件有问题，请检查配置文件【env.properties】中的hsf_especial_config");
				continue;
			}
			String[] configs = values[1].split(",");
			Set<String> configsSet = new HashSet<String>(configs.length);
			for (String config : configs) {
				configsSet.add(config);
			}

			phsfEspecialConfigMap.put(values[0], configsSet);
		}

		if (tempList != null) {
			for (File f : tempList) {

				String fName = f.getName();
				if (fName.contains("-service.xml")) {
					String[] names = fName.split("-");
					String name = "";

					if ("busi".equals(names[2]) || "intfce".equals(names[2]) || "function".equals(names[2])) {
						name = names[2];
					}
					else {
						continue;
					}
					
					// 接口工程由于命名和之前的不一样，需要修改一下
					String cBasePath = basePath;
					String pPath = "";
					if(cBasePath.contains("/card_plan_function")){
						//制卡管理工程特殊处理
						if(fName.contains("phsf")){
							continue;
						}
						
						if(fName.contains("busi")){
							cBasePath = cBasePath.replaceAll("fcenter", "bapi");
						}else if(fName.contains("function")) {
							cBasePath = cBasePath.replaceAll("fcenter", "fapi");
						}
						
						System.out.println("cBasePath = "+cBasePath);
						pPath = basePath;
						System.out.println("pPath = "+pPath);
						
					}else{
						if (cBasePath.endsWith("_interface") && "interface".equals(names[2])) {
							cBasePath = cBasePath.replace("_interface", "");
						}
						
						if(cBasePath.contains("function") || cBasePath.contains("interface")){
							if(fName.contains("busi")){
								cBasePath = cBasePath.replaceAll("impl", "busi_api");
							}else {
								cBasePath = cBasePath.replaceAll("impl", "api");
							}
						}else {
							if(fName.contains("busi")){
								cBasePath = cBasePath.replaceAll("impl", "busi_api");
							} else if (fName.contains("function")) {
								cBasePath = cBasePath.replaceAll("impl", "function_api");
							} else if (fName.contains("intfce")) {
								cBasePath = cBasePath.replaceAll("impl", "interface_api");
							}
						}
						System.out.println("cBasePath = "+cBasePath);
						pPath = basePath.replaceAll("impl", "center");
						System.out.println("basePath = "+basePath);
					}
					

					String cPath = cBasePath + "/src/main/resources/spring/" + fName.replace("-service.xml", "-chsf.xml");
					pPath = pPath + "/src/main/resources/spring/" + fName.replace("-service.xml", "-phsf.xml");
					try {
						transformationService(f.getPath(), cPath, pPath, fName, saleInterfaceSet, openMqCunsumer, chsfEspecialConfigMap, phsfEspecialConfigMap);
					}
					catch (Exception e) {
						log.error("生成hsf配置文件出错！请检查配置文件【" + f.getPath() + "】", e);
					}
				}
			}
		}
	}
	
    /**
     * 修改消费者env配置文件中的TargetIp
     * @param filePath
     * @param props
     */
    public static void changePropertiesFile() {
    	log.info("开始修改消费者env配置文件中的TargetIp");
    	String basePath = System.getProperty("user.dir").replace("\\", "/");
    	String filePath = basePath + "/src/main/resources/env.properties";
		log.info("basePath = "+basePath);
		log.info("filePath = "+filePath);
		File file = new File(filePath);
		if (!file.exists()){
			log.info("env.properties配置文件不存在，无法修改消费者env配置文件中的TargetIp。");
			return;
        }
        // 获取虚拟机IP 
        String vpnIp = getVPNIpAddress();
        log.info("vpnIp = "+vpnIp);
        if(StringUtils.isBlank(vpnIp)){
        	log.info("获取到的VPN地址为空，请检查VPN连接是否正常！");
        	return;
        }
        try {
        	PropertiesConfiguration propConfig  = new PropertiesConfiguration(filePath);
        	propConfig.setAutoSave(true);
        	String targetIp = propConfig.getString("target_IP");
            if(StringUtils.isNotBlank(targetIp) && targetIp.contains("127.0.0.1")){
            	targetIp = targetIp.replaceAll("127.0.0.1", vpnIp);
            	propConfig.setProperty("target_IP", targetIp);
            }
            
            String cardtargetIp = propConfig.getString("CARDTARGET_IP");
            if(StringUtils.isNotBlank(cardtargetIp) && cardtargetIp.contains("127.0.0.1")){
            	cardtargetIp = cardtargetIp.replaceAll("127.0.0.1", vpnIp);
            	propConfig.setProperty("CARDTARGET_IP", cardtargetIp);
            }
            
            String usertarget_ip = propConfig.getString("USERTARGET_IP");
            if(StringUtils.isNotBlank(usertarget_ip) && usertarget_ip.contains("127.0.0.1")){
            	usertarget_ip = usertarget_ip.replaceAll("127.0.0.1", vpnIp);
            	propConfig.setProperty("USERTARGET_IP", usertarget_ip);
            }
            
            String numtargetIp = propConfig.getString("NUMTARGET_IP");
            if(StringUtils.isNotBlank(numtargetIp) && numtargetIp.contains("127.0.0.1")){
            	numtargetIp = numtargetIp.replaceAll("127.0.0.1", vpnIp);
            	propConfig.setProperty("NUMTARGET_IP", numtargetIp);
            }
            
            String searchtargetIp = propConfig.getString("SEARCHTARGET_IP");
            if(StringUtils.isNotBlank(searchtargetIp) && searchtargetIp.contains("127.0.0.1")){
            	searchtargetIp = searchtargetIp.replaceAll("127.0.0.1", vpnIp);
            	propConfig.setProperty("SEARCHTARGET_IP", searchtargetIp);
            }
            
            String sysmgrTargetIp = propConfig.getString("HSF_SYSMGR_TARGET_IP");
            if(StringUtils.isNotBlank(sysmgrTargetIp) && sysmgrTargetIp.contains("127.0.0.1")){
            	sysmgrTargetIp = sysmgrTargetIp.replaceAll("127.0.0.1", vpnIp);
            	propConfig.setProperty("HSF_SYSMGR_TARGET_IP", sysmgrTargetIp);
            }
            
            String timedtasktargetIp = propConfig.getString("TIMEDTASKTARGET_IP");
            if(StringUtils.isNotBlank(timedtasktargetIp) && timedtasktargetIp.contains("127.0.0.1")){
            	timedtasktargetIp = timedtasktargetIp.replaceAll("127.0.0.1", vpnIp);
            	propConfig.setProperty("TIMEDTASKTARGET_IP", timedtasktargetIp);
            }
        } catch (Exception e) {
        	log.info("修改消费者env配置文件中的TargetIp出现异常",e);
        }
    }
    
    public static String getVPNIpAddress() {
		String ipAddress = null;
		try {
			for (Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces(); enumeration.hasMoreElements();) {
				NetworkInterface item = enumeration.nextElement();
				log.debug("item.getDisplayName() = "+item.getDisplayName());
				if (StringUtils.isNotBlank(item.getDisplayName()) && item.getDisplayName().contains("VPN")) {
					for (InterfaceAddress address : item.getInterfaceAddresses()) {
						if (address.getAddress() instanceof Inet4Address) {
							Inet4Address inet4Address = (Inet4Address) address.getAddress();
							ipAddress = inet4Address.getHostAddress();
							log.debug(inet4Address.getHostAddress());
						}
					}
				}
			}
		} catch (IOException ex) {
			log.debug("获取VPN IP地址异常，请检查VPN是否已连接！");
		}
		return ipAddress;
	}
	

	/** 转化serve成chsf和phsf <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param path
	 *        service的路径
	 * @param cPath
	 *        消费者的路径
	 * @param pPath
	 *        服务提供者的路径
	 * @param fileName
	 *        service的文件名
	 * @throws Exception
	 * @autho liuce
	 * @time 2016年8月27日 下午4:34:41 */
	private static void transformationService(String path, String cPath, String pPath, String fileName, Set<String> saleInterfaces, boolean openMqCunsumer,
	        Map<String, Set<String>> chsfEspecialConfigMap, Map<String, Set<String>> phsfEspecialConfigMap) throws Exception {
		String[] fs = fileName.split("-");

		String projectName = fs[1];

		// 创建saxReader对象
		SAXReader reader = new SAXReader();
		// 通过read方法读取一个文件 转换成Document对象
		Document document = reader.read(new File(path));
		// 获取根节点元素对象
		Element node = document.getRootElement();

		String description = node.element("description").getText();

		// 创建chsf的xml文件
		Document cdoc = DocumentHelper.createDocument();
		Element cbeans = cdoc.addElement("beans", "http://www.springframework.org/schema/beans");

		Document pdoc = DocumentHelper.createDocument();
		Element pbeans = pdoc.addElement("beans", "http://www.springframework.org/schema/beans");

		cbeans.addElement("description").setText(description.replace("service", "hsf服务调用者"));

		pbeans.addElement("description").setText(description.replace("service", "hsf服务提供者"));

		setNamespace(cbeans);
		setNamespace(pbeans);

		// 获取service中的所有的bean
		List<Element> list = node.elements("bean");
		for (Element e : list) {
			String id = e.attributeValue("id");
			// String className = e.attributeValue("class").replace(".impl", "").replace("ServiceImpl", "Service");
			// if(className.substring(className.length()-4).equals("Impl")){
			// className = className.substring(0,className.length()-4);
			// }
			String className = null;
			try {
				className = e.attributeValue("class");

				Class<?> claz = Class.forName(className);
				className = claz.getInterfaces()[0].getName();
				if (openMqCunsumer) {
					if (saleInterfaces.contains(className) || className.indexOf(".busi.") != -1) {
						log.debug("生成接口类能力：" + className);
						setHsfConsumer(cbeans, id, className, projectName, chsfEspecialConfigMap.get(className));
						setHsfProvider(pbeans, id, className, projectName, phsfEspecialConfigMap.get(className));
					}
				}
				else {
					if (!saleInterfaces.contains(className)) {
						log.debug("生成功能类能力：" + className);
						setHsfProvider(pbeans, id, className, projectName, phsfEspecialConfigMap.get(className));
					}
					setHsfConsumer(cbeans, id, className, projectName, chsfEspecialConfigMap.get(className));
				}
			}
			catch (Exception e1) {
				log.error("生成hsf配置错误，请检查接口" + className, e);
			}
		}

		writer(cdoc, cPath);

		writer(pdoc, pPath);
	}

	/** 添加namespace <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param beans
	 * @autho liuce
	 * @time 2016年8月27日 下午4:33:51 */
	private static void setNamespace(Element beans) {
		beans.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
		beans.addNamespace("context", "http://www.springframework.org/schema/context");
		beans.addNamespace("hsf", "http://www.taobao.com/hsf");
		beans.addAttribute(
		        "xsi:schemaLocation",
		        "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd http://www.taobao.com/hsf  http://www.taobao.com/hsf/hsf.xsd ");
	}

	/** 添加hsf消费端配置 <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param beans
	 * @param id
	 * @param className
	 * @param projectName
	 * @autho liuce
	 * @time 2016年8月27日 下午4:34:04 */
	private static void setHsfConsumer(Element beans, String id, String className, String projectName, Set<String> chsfEspecialConfig) {
		Element hsfBean = beans.addElement("hsf:consumer");
		hsfBean.addAttribute("id", id);
		hsfBean.addAttribute("interface", className);
		hsfBean.addAttribute("version", "${" + projectName.toUpperCase() + "_VERSION}");
		hsfBean.addAttribute("group", "${" + projectName.toUpperCase() + "_GROUP}");
		if (id.equals("goodNumRuleMaintainCalcBusiService")) {
			hsfBean.addAttribute("clientTimeout", "600000");
		}
		else {
			hsfBean.addAttribute("clientTimeout", "60000");
		}
		hsfBean.addAttribute("target", "${" + projectName.toUpperCase() + "TARGET_IP}");
		// hsfBean.addAttribute("maxWaitTimeForCsAddress", "5000");

		if (CollectionUtils.isNotEmpty(chsfEspecialConfig)) {
			for (String config : chsfEspecialConfig) {
				String[] keyValue = config.split("=");
				hsfBean.addAttribute(keyValue[0], keyValue[1]);
			}
		}

	}

	/** 添加hsf提供者配置 <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param beans
	 * @param id
	 * @param className
	 * @param projectName
	 * @autho liuce
	 * @time 2016年8月27日 下午4:34:22 */
	private static void setHsfProvider(Element beans, String id, String className, String projectName, Set<String> phsfEspecialConfig) {
		Element hsfBean = beans.addElement("hsf:provider");
		hsfBean.addAttribute("id", id + "H");
		hsfBean.addAttribute("interface", className);
		hsfBean.addAttribute("ref", id);
		hsfBean.addAttribute("version", "${" + projectName.toUpperCase() + "_VERSION}");
		hsfBean.addAttribute("group", "${" + projectName.toUpperCase() + "_GROUP}");
		if (id.equals("goodNumRuleMaintainCalcBusiService")) {
			hsfBean.addAttribute("clientTimeout", "600000");
		}
		else {
			hsfBean.addAttribute("clientTimeout", "60000");
		}
		hsfBean.addAttribute("enableTXC", "true");
		hsfBean.addAttribute("serializeType", "hessian");

		if (CollectionUtils.isNotEmpty(phsfEspecialConfig)) {
			for (String config : phsfEspecialConfig) {
				String[] keyValue = config.split("=");
				hsfBean.addAttribute(keyValue[0], keyValue[1]);
			}
		}

	}

	/** 将mq配置文件互相转换<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param path
	 * @return
	 * @autho liuce
	 * @time 2016年8月26日 下午16:34:49 */
	private static void changeMQXml(String path, String newPath) throws Exception {

		// 创建saxReader对象
		SAXReader reader = new SAXReader();
		// 通过read方法读取一个文件 转换成Document对象
		Document document = reader.read(new File(path));
		// 获取根节点元素对象
		Element node = document.getRootElement();

		List<Element> list = node.elements("bean");

		for (Element e : list) {
			Attribute attr = e.attribute("class");
			String value = attr.getValue();

			switch (value) {

				case "com.chinaunicom.base.mq.rocketmq.OnsProducerImpl":
					attr.setValue("com.chinaunicom.base.mq.ons.OnsProducerImpl");
					changeProducerPropes(e);
				break;
				case "com.chinaunicom.base.mq.rocketmq.BaseProducerImpl":
					attr.setValue("com.chinaunicom.base.mq.ons.BaseProducerImpl");
				break;
				case "com.chinaunicom.base.mq.rocketmq.OnsTransProducerImpl":
					attr.setValue("com.chinaunicom.base.mq.ons.OnsTransProducerImpl");
					changeProducerPropes(e);
				break;
				case "com.chinaunicom.base.mq.rocketmq.MQLocalTransactionExecuter":
					attr.setValue("com.chinaunicom.base.mq.ons.ONSLocalTransactionExecuter");
				break;

				case "com.chinaunicom.base.mq.ons.OnsProducerImpl":
					attr.setValue("com.chinaunicom.base.mq.rocketmq.OnsProducerImpl");
					changeProducerPropes(e);
				break;
				case "com.chinaunicom.base.mq.ons.BaseProducerImpl":
					attr.setValue("com.chinaunicom.base.mq.rocketmq.BaseProducerImpl");
				break;
				case "com.chinaunicom.base.mq.ons.OnsTransProducerImpl":
					attr.setValue("com.chinaunicom.base.mq.rocketmq.OnsTransProducerImpl");
					changeProducerPropes(e);
				break;
				case "com.chinaunicom.base.mq.ons.ONSLocalTransactionExecuter":
					attr.setValue("com.chinaunicom.base.mq.rocketmq.MQLocalTransactionExecuter");
				break;

				case "com.chinaunicom.base.mq.rocketmq.BaseConsumerImpl":
					attr.setValue("com.chinaunicom.base.mq.ons.BaseConsumerImpl");
					changeProducerPropes(e);
				break;

				case "com.chinaunicom.base.mq.rocketmq.ConsumerProerties":
					attr.setValue("com.chinaunicom.base.mq.ons.ConsumerProerties");
				break;
				case "com.chinaunicom.base.mq.rocketmq.MQCunsumerImpl":
					attr.setValue("com.chinaunicom.base.mq.ons.ONSCunsumerImpl");
				break;

				case "com.chinaunicom.base.mq.ons.BaseConsumerImpl":
					attr.setValue("com.chinaunicom.base.mq.rocketmq.BaseConsumerImpl");
					changeProducerPropes(e);
				break;
				case "com.chinaunicom.base.mq.ons.ConsumerProerties":
					attr.setValue("com.chinaunicom.base.mq.rocketmq.ConsumerProerties");
				break;
				case "com.chinaunicom.base.mq.ons.ONSCunsumerImpl":
					attr.setValue("com.chinaunicom.base.mq.rocketmq.MQCunsumerImpl");
				break;

				default:
				break;
			}
		}

		writer(document, newPath);

	}

	/** 将properties的内容互相替换<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param e
	 * @autho liuce
	 * @time 2016年8月26日 下午5:11:02 */
	private static void changeProducerPropes(Element e) {
		Element constructor = e.element("constructor-arg");

		if (constructor != null) {
			changeProps(constructor);
		}
		else {
			List<Element> propertys = e.elements("property");
			for (Element property : propertys) {
				String nameValue = property.attributeValue("name");
				if ("properties".equals(nameValue)) {
					changeProps(property);
					break;
				}
			}
		}
	}

	private static void changeProps(Element elem) {
		Element props = elem.element("props");
		List<Element> prolist = props.elements("prop");
		for (Element pe : prolist) {
			Attribute pattr = pe.attribute("key");
			String pValue = pattr.getValue();

			// 将rocketmq变为ons
			if ("NAMESRV_ADDR".equals(pValue)) {
				pattr.setValue("AccessKey");
				pe.setText("${ons.AccessKey}");
				Element prop = props.addElement("prop");
				prop.addAttribute("key", "SecretKey");
				prop.setText("${ons.SecretKey}");
			}
			// 将ons变为rocketmq
			else if ("AccessKey".equals(pValue)) {
				pattr.setValue("NAMESRV_ADDR");
				pe.setText("${mq.NAMESRV_ADDR}");
			}
			// 将ons变为rocketmq
			else if ("SecretKey".equals(pValue)) {
				props.remove(pe);
			}
		}
	}

	/** 把document对象写入新的文件
	 * 
	 * @param document
	 * @throws Exception */
	private static void writer(Document document, String newPath) throws Exception {
		// 紧凑的格式
		// OutputFormat format = OutputFormat.createCompactFormat();
		// 排版缩进的格式
		OutputFormat format = OutputFormat.createPrettyPrint();
		// 设置编码
		format.setEncoding("UTF-8");
		// 创建XMLWriter对象,指定了写出文件及编码格式
		// XMLWriter writer = new XMLWriter(new FileWriter(new
		// File("src//a.xml")),format);

		File file = new File(newPath);

		FileOutputStream fileOutputStream = new FileOutputStream(file);

		OutputStreamWriter OutputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");

		XMLWriter writer = new XMLWriter(OutputStreamWriter, format);
		// 写入
		writer.write(document);
		// 立即写入
		writer.flush();
		// 关闭操作
		fileOutputStream.close();
		OutputStreamWriter.close();
		writer.close();
	}
}
