package com.ohaotian.plugin.mq.util;

import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

import com.ohaotian.plugin.base.bo.ReqInfo;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.mq.MqMessageListener;
import com.ohaotian.plugin.mq.MqProducerPool;
import com.ohaotian.plugin.mq.bo.BaseRspConstants;
import com.ohaotian.plugin.mq.bo.ReqInfceBaseBO;
import com.ohaotian.plugin.mq.bo.RspIntfaceBaseBO;
import com.ohaotian.plugin.mq.interfce.MqCunsumer;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.aliyun.openservices.ons.api.Message;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.eagleeye.EagleEye;

/**
 * <br>
 * 标题: 规范日志打印类<br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 *
 * @autho liuce
 * @time 2017年5月4日 下午5:30:22
 */
public class LogUtils {

    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);
    private static final Logger aoplog = LoggerFactory.getLogger(AOPLogger.class);
    private static final Logger busilog = LoggerFactory.getLogger(BusiLogger.class);
    private static final Logger mqlog = LoggerFactory.getLogger(MQLogger.class);
    private static final Logger aopErrorLog = LoggerFactory.getLogger(AOPErrorLogger.class);
    private static final Logger busiErrorLog = LoggerFactory.getLogger(BusiErrorLogger.class);
    private static final Logger mqErrorLog = LoggerFactory.getLogger(MQErrorLogger.class);

    /**
     * 分隔符
     */
    private static final String SEPARATOR = "|";

    /**
     * 类与方法名的连接符
     */
    private static final String CLASS_METHOD_SEPARATOR = ".";

    /**
     * 开始标识
     */
    private static final String START_IDENTIFICATION = "1";

    /**
     * 结束标识
     */
    private static final String END_IDENTIFICATION = "2";

    /**
     * 异常标识
     */
    private static final String ERROR_IDENTIFICATION = "0";

    /**
     * 生产者标识
     */
    private static final String MQPRODUCER = "1";

    /**
     * 消费者标识
     */
    private static final String MQCONSUMER = "2";

    private static final ObjectMapper mapper = new ObjectMapper();

    /**
     * 用来存放消费者的类的真实名称名
     */
    private static final Map<String, String[]> classNameMap = new ConcurrentHashMap<String, String[]>();

    /**
     * 消费者的执行方法
     */
    private static final String CONSUMER_METHOD_NAME = "execute";

    /**
     * 需要排除的方法名称
     */
    private static final String excludeMethods = "subscribe";

    /**
     * 全局配置文件
     */
    private static Properties propertyConfigurer;

    public Properties getPropertyConfigurer() {
        return propertyConfigurer;
    }

    public void setPropertyConfigurer(Properties propertyConfigurer) {
        LogUtils.propertyConfigurer = propertyConfigurer;
    }

    /**
     * <br>
     * 适用场景: 功能层和接口层的开始日志<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @autho liuce
     * @time 2017年5月4日 下午5:33:17
     */
    public static final String[] printAopStartLog(ProceedingJoinPoint pjp) {

        Long nowTime = System.currentTimeMillis();

        String[] infos = new String[21];
        // 获取目标对象对应的类名
        String className = pjp.getTarget().getClass().getName();

        // 获取目标对象上正在执行的方法名
        String methodString = pjp.getSignature().getName();
        // 目前要排除消息订阅的方法
        if (excludeMethods.equals(methodString) || CONSUMER_METHOD_NAME.equals(methodString)) {
            return null;
        }
        // 添加TraceId
        String traceId = getTraceId();
        //这里为了解决消费者里再发消息获取不到traceID的问题用了本地线程变量
        if (StringUtils.isBlank(traceId)) {
            traceId = MqMessageListener.traceIds.get();
        }
        // 添加类名.方法名
        StringBuilder classAndMethod = new StringBuilder();
        // 添加类名.方法名
        classAndMethod.append(className);
        classAndMethod.append(CLASS_METHOD_SEPARATOR);
        classAndMethod.append(methodString);
        //Traceid
        infos[0] = traceId;
        // 业务流水
        infos[1] = "";
        //类名.方法名
        infos[2] = classAndMethod.toString();
        // 添加开始标识
        infos[3] = START_IDENTIFICATION;
        // 层级
        infos[4] = "1";
        // 添加开始时间
        infos[5] = nowTime.toString();
        // 添加结束时间
        infos[6] = "";
        // 入参
        Object[] params = pjp.getArgs();

        ReqInfceBaseBO req = null;
        ReqInfo reqinfo = null;
        if (params != null && params.length > 0) {
            // 因为接口层的方法的入参是固定只有一个的，因此，只取第一个字段就可以
            // 添加关键字 这个时刻是空的
            //infos[4] = "";
            if (params[0] instanceof ReqInfceBaseBO) {
                // 外部流水（批次号）
                req = (ReqInfceBaseBO) params[0];
                String reqNo = req.getReqNo();
                if (StringUtils.isBlank(reqNo)) {
                    reqNo = "";
                }
                //commonHead.append(reqNo);
                //commonHead.append(SEPARATOR);
                // 外部流水（批次号）
                infos[7] = reqNo;
                // 号
                infos[8] = req.getSerialNumberBase();
                // 卡
                infos[9] = req.getIccidBase();
                // 省份
                infos[10] = req.getProvinceCode();
                // 地市
                infos[11] = req.getCityCode();
                // 区县
                infos[12] = req.getDistrictCode();
                // 部门
                infos[13] = req.getDepartId();
                // 渠道
                infos[14] = req.getChannelId();
                // 工号
                infos[15] = req.getProvinceCode() + "_" + req.getStaffId();
                // 请求报文
                try {
                    infos[16] = mapper.writeValueAsString(params[0]);
                } catch (JsonProcessingException e) {
                    infos[16] = ("请求报文转json出错，改用toString方法" + params[0]).replace("\r\n", "");
                }
                // 响应报文
                infos[17] = "";
                // 应答码
                infos[18] = "";
                //应答描述
                infos[19] = "";
                //异常信息
                infos[20] = "";
            }
        }
        // 打印接口服务请求日志
        aoplog.info(getLogInfoByStrings(infos));

        return infos;
    }

    /**
     * <br>
     * 适用场景: 打印接口层和功能层的错误日志，需要与开始日志一起用<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param infos
     * @param keyWord
     * @param e
     * @autho liuce
     * @time 2017年5月4日 下午6:00:22
     */
    public static void printAopErrorLog(String[] infos, String keyWord, Throwable e) {

        if (infos == null) {
            return;
        }

        Long nowTime = System.currentTimeMillis();
        // 修改标识为结束标识
        infos[3] = ERROR_IDENTIFICATION;
        // 添加结束时间
        infos[6] = nowTime.toString();
        // 添加关键字:8888
        infos[18] = BaseRspConstants.RSP_CODE_FAILUR;
        // 异常信息
        infos[20] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");


	/*	// 修改标识为结束标识
		infos[1] = ERROR_IDENTIFICATION;
		// 添加结束时间
		infos[3] = nowTime.toString();
		// 添加关键字
		infos[4] = keyWord;
		// 异常信息
		infos[12] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
*/
        // 打印接口服务异常日志
        aopErrorLog.error(getLogInfoByStrings(infos));
    }

    public static void printAopEndLog(String[] infos, String keyWord, Object obj) {

        if (infos == null) {
            return;
        }

        Long nowTime = System.currentTimeMillis();
        // 修改标识为结束标识
        infos[3] = END_IDENTIFICATION;
        // 添加结束时间
        infos[6] = nowTime.toString();

        if (obj != null && obj instanceof RspIntfaceBaseBO) {
            RspIntfaceBaseBO o = (RspIntfaceBaseBO) obj;
            // 响应报文|
            try {
                infos[17] = mapper.writeValueAsString(obj);
            } catch (JsonProcessingException e) {
                infos[17] = ("请求报文转json出错，改用toString方法" + obj).replace("\r\n", "");
            }

            // 应答码
            infos[18] = o.getRespCode();
            // 应答描述
            infos[19] = o.getRespDesc();
        } else if (obj != null && obj instanceof RspBaseBO) {
            RspBaseBO o = (RspBaseBO) obj;
            // 响应报文|
            try {
                infos[17] = mapper.writeValueAsString(obj);
            } catch (JsonProcessingException e) {
                infos[17] = ("请求报文转json出错，改用toString方法" + obj).replace("\r\n", "");
            }

            // 应答码
            infos[18] = o.getCode();
            // 应答描述
            infos[19] = o.getMessage();
        }

        // 打印接口服务结束日志
        aoplog.info(getLogInfoByStrings(infos));
    }

    /**
     * <br>
     * 适用场景: 打印mq生产者日志<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param body
     * @autho liuce
     * @time 2017年5月4日 下午6:33:10
     */
    public static final void printMQProducerLog(String className, String method, Message msg, Object body) {
        Long nowTime = System.currentTimeMillis();
        // 添加edas TraceId
        //StringBuilder traceId = new StringBuilder(getTraceId());


        String[] infos = new String[18];

        // 获取目标对象对应的类名
        // TODO 目前没办法获取 只能靠传过来，目前事务消息传待执行的本地事务的类名和方法名
        // String className = pjp.getTarget().getClass().getName();

        // 获取目标对象上正在执行的方法名
        // String methodString = pjp.getSignature().getName();
        // TODO 目前没办法获取
        // 添加类名.方法名
        StringBuilder classAndMethod = new StringBuilder();

        classAndMethod.append(className);
        classAndMethod.append(CLASS_METHOD_SEPARATOR);
        classAndMethod.append(method);

        // 添加edas TraceId
        //	infos[0] = traceId.toString();
        infos[0] = msg.getUserProperties("TraceId");
        // 业务流水
        infos[1] = "";
        // 类名.方法名
        infos[2] = classAndMethod.toString();
        // 类型
        infos[3] = MQPRODUCER;
        // 添加开始标识
        infos[4] = START_IDENTIFICATION;
        // 层级
        infos[5] = "1.1";
        // 添加开始时间
        infos[6] = nowTime.toString();
        // 添加结束时间
        infos[7] = infos[6];
        // 生产者ID
        infos[8] = MqProducerPool.producerIds.get(msg.getTopic());
        // topic
        infos[9] = msg.getTopic();
        // tag
        infos[10] = msg.getTag();
        // 外部流水（批次号）
        infos[11] = "";
        // 消息id
        infos[12] = msg.getMsgID();
        // 关键字
        infos[13] = msg.getKey();
        // 号
        infos[14] = "";
        // 卡
        infos[15] = "";

        try {
            infos[16] = mapper.writeValueAsString(body);
        } catch (JsonProcessingException e) {
            infos[16] = ("请求报文转json出错，改用toString方法" + body).replace("\r\n", "");
        }
	/*	// 添加edas TraceId
		StringBuilder commonHead = new StringBuilder(getTraceId() + SEPARATOR);

		// 添加业务流水 ，就是消息的msgID
		commonHead.append(msg.getMsgID());
		commonHead.append(SEPARATOR);

		String[] infos = new String[9];

		// 获取目标对象对应的类名
		// TODO 目前没办法获取 只能靠传过来，目前事务消息传待执行的本地事务的类名和方法名
		// String className = pjp.getTarget().getClass().getName();

		// 获取目标对象上正在执行的方法名
		// String methodString = pjp.getSignature().getName();
		// TODO 目前没办法获取
		// 添加类名.方法名
		commonHead.append(className);
		commonHead.append(CLASS_METHOD_SEPARATOR);
		commonHead.append(method);
		commonHead.append(SEPARATOR);
		commonHead.append(MQPRODUCER);

		infos[0] = commonHead.toString();
		// 添加开始标识
		infos[1] = START_IDENTIFICATION;
		// 添加开始时间
		infos[2] = nowTime.toString();
		// 添加结束时间
		infos[3] = infos[2];

		// topic
		infos[5] = msg.getTopic();

		// 生产者ID
		infos[4] = MqProducerPool.producerIds.get(infos[5]);

		// tag
		infos[6] = msg.getTag();

		// 关键字
		infos[7] = msg.getKey();

		try {
			infos[8] = mapper.writeValueAsString(body);
		}
		catch (JsonProcessingException e) {
			infos[8] = ("请求报文转json出错，改用toString方法" + body).replace("\r\n", "");
		}
*/
        // 打印请求日志
        mqlog.info(getLogInfoByStrings(infos));
    }

    /**
     * <br>
     * 适用场景: 打印发送消息的错误日志<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param e
     * @autho liuce
     * @time 2017年5月4日 下午6:00:22
     */
    public static void printMQErrorLog(String className, String method, Message msg, Object body, Throwable e) {

        Long nowTime = System.currentTimeMillis();
        // 添加edas TraceId
        //StringBuilder traceId = new StringBuilder(getTraceId());


        String[] infos = new String[18];

        // 获取目标对象对应的类名
        // TODO 目前没办法获取 只能靠传过来，目前事务消息传待执行的本地事务的类名和方法名
        // String className = pjp.getTarget().getClass().getName();

        // 获取目标对象上正在执行的方法名
        // String methodString = pjp.getSignature().getName();
        // TODO 目前没办法获取
        // 添加类名.方法名
        StringBuilder classAndMethod = new StringBuilder();

        classAndMethod.append(className);
        classAndMethod.append(CLASS_METHOD_SEPARATOR);
        classAndMethod.append(method);

        // 添加edas TraceId
        //infos[0] = traceId.toString();
        infos[0] = msg.getUserProperties("TraceId");
        // 业务流水
        infos[1] = "";
        // 类名.方法名
        infos[2] = classAndMethod.toString();
        // 类型
        infos[3] = MQPRODUCER;
        // 添加开始标识
        infos[4] = ERROR_IDENTIFICATION;
        // 层级
        infos[5] = "1.1";
        // 添加开始时间
        infos[6] = nowTime.toString();
        // 添加结束时间
        infos[7] = infos[6];
        // 生产者ID
        infos[8] = MqProducerPool.producerIds.get(msg.getTopic());
        // topic
        infos[9] = msg.getTopic();
        // tag
        infos[10] = msg.getTag();
        // 外部流水（批次号）
        infos[11] = "";
        // 消息id
        infos[12] = msg.getMsgID();
        // 关键字
        infos[13] = msg.getKey();
        // 号
        infos[14] = "";
        // 卡
        infos[15] = "";

        try {
            infos[16] = mapper.writeValueAsString(body);
        } catch (JsonProcessingException ex) {
            infos[16] = ("请求报文转json出错，改用toString方法" + body).replace("\r\n", "");
        }
        // 添加异常
        infos[17] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");

/*
		// 添加edas TraceId
		StringBuilder commonHead = new StringBuilder(getTraceId() + SEPARATOR);

		// 添加业务流水 ，就是消息的msgID
		commonHead.append(msg.getMsgID());
		commonHead.append(SEPARATOR);

		String[] infos = new String[10];

		// 获取目标对象对应的类名
		// TODO 目前没办法获取 只能靠传过来，目前事务消息传待执行的本地事务的类名和方法名
		// String className = pjp.getTarget().getClass().getName();

		// 获取目标对象上正在执行的方法名
		// String methodString = pjp.getSignature().getName();
		// TODO 目前没办法获取
		// 添加类名.方法名
		commonHead.append(className);
		commonHead.append(CLASS_METHOD_SEPARATOR);
		commonHead.append(method);
		commonHead.append(SEPARATOR);
		commonHead.append(MQPRODUCER);

		infos[0] = commonHead.toString();
		// 添加开始标识
		infos[1] = ERROR_IDENTIFICATION;
		// 添加开始时间
		infos[2] = nowTime.toString();
		// 添加结束时间
		infos[3] = infos[2];

		// topic
		infos[5] = msg.getTopic();

		// 生产者ID
		infos[4] = MqProducerPool.producerIds.get(infos[5]);

		// tag
		infos[6] = msg.getTag();

		// 关键字
		infos[7] = msg.getKey();

		try {
			infos[8] = mapper.writeValueAsString(body);
		}
		catch (JsonProcessingException ex) {
			infos[8] = ("请求报文转json出错，改用toString方法" + body).replace("\r\n", "");
		}

		// 添加异常
		infos[9] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
*/
        // 打印mq生产者异常日志
        mqErrorLog.error(getLogInfoByStrings(infos));
    }

    /**
     * <br>
     * 适用场景: 打印消费者开始日志<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param msg
     * @autho liuce
     * @time 2017年5月4日 下午7:11:35
     */
    public static final String[] printMQConsumerStartLog(final Message msg, final MqCunsumer consumer, Object obj) {

        String[] infos = getMQConsumerStartLog(msg, consumer, obj);
        // 打印接口服务请求日志
        mqlog.info(getLogInfoByStrings(infos));
/*		// 添加edas TraceId
		StringBuilder commonHead = new StringBuilder(getTraceId() + SEPARATOR);

		// 添加业务流水 ，就是消息的msgID
		commonHead.append(msg.getMsgID());
		commonHead.append(SEPARATOR);

		String[] infos = new String[9];

		// 获取目标对象对应的类名
		String className = null;
		// 先判断这个类是否是代理类，如果是的话，则或者代理的真正的类
		if (Proxy.isProxyClass(consumer.getClass())) {
			className = Proxy.getInvocationHandler(consumer).getClass().getName();
		}
		else {
			className = consumer.getClass().getName();
		}

		String[] consumerInfos = classNameMap.get(className);
		if (consumerInfos == null) {
			consumerInfos = new String[2];
			// 存放类名称
			consumerInfos[0] = className;
			// 存放消费者ID
			consumerInfos[1] = props.getProperty(consumer.subscribe().getConsumerId());
			classNameMap.put(className, consumerInfos);
		}

		// 添加类名.方法名
		commonHead.append(consumerInfos[0]);
		commonHead.append(CLASS_METHOD_SEPARATOR);
		commonHead.append(CONSUMER_METHOD_NAME);
		commonHead.append(SEPARATOR);
		commonHead.append(MQCONSUMER);

		infos[0] = commonHead.toString();
		// 添加开始标识
		infos[1] = START_IDENTIFICATION;
		// 添加开始时间
		infos[2] = nowTime.toString();
		// 添加结束时间
		infos[3] = "";

		// 消费者ID
		infos[4] = consumerInfos[1];

		// topic
		infos[5] = msg.getTopic();

		// tag
		infos[6] = msg.getTag();

		// 关键字
		infos[7] = msg.getKey();

		// 打印接口服务请求日志
		mqlog.info(getLogInfoByStrings(infos));*/

        return infos;
    }


    /**
     * <br>
     * 适用场景: 获取消费者开始日志<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param msg
     * @autho liuce
     * @time 2017年5月4日 下午7:11:35
     */
    public static final String[] getMQConsumerStartLog(Message msg, MqCunsumer consumer, Object obj) {
        Long nowTime = System.currentTimeMillis();
        // 添加edas TraceId
        //StringBuilder traceId = new StringBuilder(getTraceId());
        String[] infos = new String[18];

        // 获取目标对象对应的类名
        String className = null;
        // 先判断这个类是否是代理类，如果是的话，则或者代理的真正的类
        if (Proxy.isProxyClass(consumer.getClass())) {
            className = Proxy.getInvocationHandler(consumer).getClass().getName();
        } else {
            className = consumer.getClass().getName();
        }

        String[] consumerInfos = classNameMap.get(className);
        if (consumerInfos == null) {
            consumerInfos = new String[2];
            // 存放类名称
            consumerInfos[0] = className;
            // 存放消费者ID
            consumerInfos[1] = propertyConfigurer.getProperty(consumer.subscribe().getConsumerId());
            classNameMap.put(className, consumerInfos);
        }
        // 添加类名.方法名
        StringBuilder classAndMethod = new StringBuilder();
        // 添加类名.方法名
        classAndMethod.append(consumerInfos[0]);
        classAndMethod.append(CLASS_METHOD_SEPARATOR);
        classAndMethod.append(CONSUMER_METHOD_NAME);

        // 添加edas TraceId
        //infos[0] = traceId.toString();
        infos[0] = msg.getUserProperties("TraceId");

        // 这里先存到本地线程变量中
        MqMessageListener.traceIds.set(infos[0]);

        // 业务流水
        infos[1] = "";
        // 类名.方法名
        infos[2] = classAndMethod.toString();
        // 类型
        infos[3] = MQCONSUMER;
        // 添加开始标识
        infos[4] = START_IDENTIFICATION;
        // 层级
        infos[5] = "1.1";
        // 添加开始时间
        infos[6] = nowTime.toString();
        // 添加结束时间
        infos[7] = "";
        // 消费者ID
        infos[8] = consumerInfos[1];
        // topic
        infos[9] = msg.getTopic();
        // tag
        infos[10] = msg.getTag();
        // 外部流水（批次号）
        infos[11] = "";
        // 消息id
        infos[12] = msg.getMsgID();
        // 关键字
        infos[13] = msg.getKey();
        // 号
        infos[14] = "";
        // 卡
        infos[15] = "";
        // 请求参数
        if (obj != null) {
            try {
                infos[16] = mapper.writeValueAsString(obj);
            } catch (JsonProcessingException ex) {
                infos[16] = ("请求报文转json出错，改用toString方法" + obj).replace("\r\n", "");
            }
        }

        return infos;
    }

    /**
     * <br>
     * 适用场景: 打印消费者结束日志，需要结合开始日志使用<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param infos
     * @autho liuce
     * @time 2017年5月4日 下午7:22:13
     */
    public static void printMQConsumerEndLog(String[] infos) {
        Long nowTime = System.currentTimeMillis();

        // 修改标识为结束标识
        infos[4] = END_IDENTIFICATION;
        // 添加结束时间
        infos[7] = nowTime.toString();

        // 打印接口服务结束日志
        mqlog.info(getLogInfoByStrings(infos));
    }

    /**
     * <br>
     * 适用场景: 打印消费者错误日志，需要结合开始日志使用<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param infos
     * @autho liuce
     * @time 2017年5月4日 下午7:22:13
     */
    public static void printMQConsumerErrorLog(String[] infos, Throwable e) {
        Long nowTime = System.currentTimeMillis();

        // 修改标识为异常标识
        infos[4] = ERROR_IDENTIFICATION;
        // 添加结束时间
        infos[7] = nowTime.toString();
        // 异常信息
        infos[17] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        // 打印接口服务结束日志
        mqlog.info(getLogInfoByStrings(infos));
    }

    /**
     * <br>
     * 适用场景: 业务层的开始日志<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @autho liuce
     * @time 2017年5月4日 下午5:33:17
     */
    public static final String[] printBusiAopStartLog(ProceedingJoinPoint pjp) {

        Long nowTime = System.currentTimeMillis();
        // 添加TraceId
        String traceId = getTraceId();
        //这里为了解决消费者里再发消息获取不到traceID的问题用了本地线程变量
        if (StringUtils.isBlank(traceId)) {
            traceId = MqMessageListener.traceIds.get();
        }

        // 获取目标对象对应的类名
        String className = pjp.getTarget().getClass().getName();

        // 获取目标对象上正在执行的方法名
        String methodString = pjp.getSignature().getName();

        // 目前要排除消息订阅的方法
        if (excludeMethods.equals(methodString) || CONSUMER_METHOD_NAME.equals(methodString)) {
            return null;
        }
        // 添加类名.方法名
        StringBuilder classAndMethod = new StringBuilder();
        // 添加类名.方法名
        classAndMethod.append(className);
        classAndMethod.append(CLASS_METHOD_SEPARATOR);
        classAndMethod.append(methodString);

        String[] infos = new String[21];
        // 添加edas TraceId
        infos[0] = traceId;
        // 添加类名.方法名
        infos[2] = classAndMethod.toString();
        // 添加开始标识
        infos[3] = START_IDENTIFICATION;
        // 层级
        infos[4] = "1.1";
        // 添加开始时间
        infos[5] = nowTime.toString();
        // 添加结束时间
        infos[6] = "";

        // 入参
        Object[] params = pjp.getArgs();

        if (params != null && params.length > 0) {
            if (params.length == 1) {
                // 请求报文
                try {
                    infos[16] = mapper.writeValueAsString(params[0]);
                } catch (JsonProcessingException e) {
                    infos[16] = ("请求报文转json出错，改用toString方法" + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");

                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = mapper.writeValueAsString(obj);
                        } catch (JsonProcessingException e) {
                            objStr = null;
                        }
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }

                paramsStr.setLength(paramsStr.length() - 1);

                paramsStr.append("]");
                infos[16] = paramsStr.toString();
            }
        }

/*		// 添加edas TraceId
		StringBuilder commonHead = new StringBuilder(getTraceId() + SEPARATOR);
		// 获取目标对象对应的类名
		String className = pjp.getTarget().getClass().getName();

		// 获取目标对象上正在执行的方法名
		String methodString = pjp.getSignature().getName();

		// 目前要排除消息订阅的方法
		if (excludeMethods.equals(methodString)) {
			return null;
		}

		// 添加类名.方法名
		commonHead.append(className);
		commonHead.append(CLASS_METHOD_SEPARATOR);
		commonHead.append(methodString);

		String[] infos = new String[6];

		infos[0] = commonHead.toString();
		// 添加开始标识
		infos[1] = START_IDENTIFICATION;
		// 添加开始时间
		infos[2] = nowTime.toString();
		// 添加结束时间
		infos[3] = "";

		// 入参
		Object[] params = pjp.getArgs();

		if (params != null && params.length > 0) {
			if (params.length == 1) {
				// 请求报文
				try {
					infos[4] = mapper.writeValueAsString(params[0]);
				}
				catch (JsonProcessingException e) {
					infos[4] = ("请求报文转json出错，改用toString方法" + params[0]).replace("\r\n", "");
				}
			}
			else {
				StringBuilder paramsStr = new StringBuilder();
				paramsStr.append("[");

				for (Object obj : params) {
					String objStr = null;
					if (obj != null) {
						try {
							objStr = mapper.writeValueAsString(obj);
						}
						catch (JsonProcessingException e) {
							objStr = null;
						}
					}
					paramsStr.append(objStr);
					paramsStr.append(",");
				}

				paramsStr.setLength(paramsStr.length() - 1);

				paramsStr.append("]");
			}
		}
*/
        // 打印接口服务请求日志
        busilog.info(getLogInfoByStrings(infos));

        return infos;
    }

    /**
     * <br>
     * 适用场景: 业务层的错误日志，需要与开始日志一起用<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param infos
     * @param e
     * @autho liuce
     * @time 2017年5月4日 下午6:00:22
     */
    public static void printBusiAopErrorLog(String[] infos, Throwable e) {

        if (infos == null) {
            return;
        }

        Long nowTime = System.currentTimeMillis();
        // 修改标识为结束标识
        infos[3] = ERROR_IDENTIFICATION;
        // 添加结束时间
        infos[6] = nowTime.toString();
        // 添加关键字:8888
        infos[18] = BaseRspConstants.RSP_CODE_FAILUR;
        // 异常信息
        infos[20] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
/*		// 修改标识为结束标识
		infos[1] = ERROR_IDENTIFICATION;
		// 添加结束时间
		infos[3] = nowTime.toString();
		// 异常信息
		infos[5] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
*/
        // 打印接口服务异常日志
        busiErrorLog.error(getLogInfoByStrings(infos));
    }

    /**
     * <br>
     * 适用场景: 业务层结束日志，与开始日志配合使用<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param infos
     * @autho liuce
     * @time 2017年5月10日 下午2:44:38
     */
    public static void printBusiAopEndLog(String[] infos) {

        if (infos == null) {
            return;
        }

        Long nowTime = System.currentTimeMillis();
        // 修改标识为结束标识
        infos[3] = END_IDENTIFICATION;
        // 添加结束时间
        infos[6] = nowTime.toString();
/*		// 响应报文|
		try {
			infos[17] = mapper.writeValueAsString(obj);
		}
		catch (JsonProcessingException e) {
			infos[17] = ("请求报文转json出错，改用toString方法" + obj).replace("\r\n", "");
		}*/


	/*	// 修改标识为结束标识
		infos[1] = END_IDENTIFICATION;
		// 添加结束时间
		infos[3] = nowTime.toString();*/
        // 打印接口服务结束日志
        busilog.info(getLogInfoByStrings(infos));
    }

    private static final String getLogInfoByStrings(String[] infos) {
        StringBuilder stb = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank(info)) {
                info = "";
            }
            stb.append(info + SEPARATOR);
        }
        if (stb.length() > 1) {
            stb.setLength(stb.length() - 1);
        }
        return stb.toString();
    }

    private static final String getTraceId() {
        String traceId = EagleEye.getTraceId();
        if (StringUtils.isBlank(traceId)) {
            traceId = "";
        }
        return traceId;
    }

}

final class AOPLogger {

}

final class AOPErrorLogger {

}

final class BusiLogger {

}

final class BusiErrorLogger {

}

final class MQLogger {

}

final class MQErrorLogger {

}
