package com.ohaotian.plugin.mq;

import java.util.Date;
import java.util.List;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.SerializeUtils;
import com.ohaotian.plugin.mq.bo.MessageInfoBO;
import com.ohaotian.plugin.mq.bo.MqConstants;
import com.ohaotian.plugin.mq.bo.MqSubScribeSingleBO;
import com.ohaotian.plugin.mq.interfce.MqCunsumer;
import com.ohaotian.plugin.mq.util.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;


/** <br>
 * 标题: 自己实现的消息监听类<br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho liuce
 * @time 2016年9月24日 下午11:33:28 */
public class MqMessageListener implements MessageListener {

	public MqMessageListener(CacheClient cacheService, List<MqCunsumer> mqcList, String subExpression) {
		super();
		this.cacheService = cacheService;
		this.mqcList = mqcList;
		this.subExpression = subExpression;
	}

	private final static Logger log            = LoggerFactory.getLogger(MqMessageListener.class);

	private final boolean       isDebugEnabled = log.isDebugEnabled();
	
	/**
	 * 本地线程变量用來存储traceid
	 */
	public static final ThreadLocal<String> traceIds = new ThreadLocal<String>();

	/** 缓存service */
	private CacheClient        cacheService;


	/** tag */
	private String              subExpression;
	
	private List<MqCunsumer>  mqcList;
	

	/** 设置 缓存service
	 * 
	 * @param cacheService
	 *        缓存service */
	public void setCacheService(CacheClient cacheService) {
		this.cacheService = cacheService;
	}

	/** 设置 tag
	 * 
	 * @param
	 *         */
	public void setTag(String subExpression) {
		this.subExpression = subExpression;
	}

	@Override
	public Action consume(Message msg, ConsumeContext context) {

		if (isDebugEnabled) {
			log.info("msgid:[" + msg.getMsgID() + "]topic[" + msg.getTopic() + "]tag[" + msg.getTag() + "]key[" + msg.getKey() + "]");
		}

		String msgId = msg.getMsgID();
		String topic = msg.getTopic();
		String tag = msg.getTag();
		String key = msg.getKey();
		byte[] body = msg.getBody();

		Action ret = null;
		String[] infos = null;
		try {
			Object msginfo = SerializeUtils.deserialize(body);

			// 打印开始日志
			for(MqCunsumer mqc:mqcList){
				MqSubScribeSingleBO bo=mqc.subscribe();
				if("*".equals(bo.getTag())){
					infos = LogUtils.printMQConsumerStartLog(msg, mqc,msginfo);
					mqc.execute(tag, msginfo);
					ret = Action.CommitMessage;
				}
				if(tag.equals(bo.getTag())){
					infos = LogUtils.printMQConsumerStartLog(msg, mqc,msginfo);
					mqc.execute(tag, msginfo);
					ret = Action.CommitMessage;
				}
			}

			// 打印结束日志
			LogUtils.printMQConsumerEndLog(infos);

		}
		catch (Exception e) {
			log.error("消费失败！msgId =" + msgId + "消息的主题是" + topic + "消息的tag=" + tag, e);
			ret = Action.ReconsumeLater;
			// 打印错误日志
			LogUtils.printMQConsumerErrorLog(infos, e);
		}

		//
		// MessageInfoBO msgInfo = (MessageInfoBO) cacheService.get(MqConstants.MQ_PREFIX + msg.getMsgID());
		//
		// if (msgInfo != null) {
		// if (!MqConstants.CONSUMER_STATUS_SUCCESS.equals(msgInfo.getConsumerStatus()) &&
		// !MqConstants.CONSUMER_STATUS_UPDATE.equals(msgInfo.getConsumerStatus())) {
		// try {
		// // 如果发送信息不存在则进行插入接口信息。
		// updateMessageInfoBO(msgInfo, MqConstants.CONSUMER_STATUS_UPDATE);
		// Object msginfo = SerializeUtils.deserialize(msg.getBody());
		// mqc.execute(tag, msginfo);
		// updateMessageInfoBO(msgInfo, MqConstants.CONSUMER_STATUS_SUCCESS);
		// ret = Action.CommitMessage;
		// }
		// catch (Exception e) {
		// log.error("msgid:[" + msgId + "]topic[" + topic + "]tag[" + tag + "]key[" + key + "] 消费失败……", e);
		// updateMessageInfoBO(msgInfo, MqConstants.CONSUMER_STATUS_FAILURE);
		// ret = Action.ReconsumeLater;
		// }
		// }
		// else if (MqConstants.CONSUMER_STATUS_SUCCESS.equals(msgInfo.getConsumerStatus())) { // 否则不带用相应接口
		// log.info("msgid:[" + msgId + "]topic[" + topic + "]tag[" + tag + "]key[" + key + "] 已消费，不需要处理");
		// ret = Action.CommitMessage;
		// }
		// else {
		// log.warn("msgid:[" + msgId + "]topic[" + topic + "]tag[" + tag + "]key[" + key + "] 正在处理中…… 请稍后处理");
		// ret = Action.ReconsumeLater;
		// }
		// }
		// else {
		// // 如果没有查到信息说明
		// log.warn("msgid:[" + msgId + "]topic[" + topic + "]tag[" + tag + "]key[" + key + "] 没有查到发送信息……");
		// try {
		// msgInfo = new MessageInfoBO();
		// msgInfo.setMsgId(msgId);
		// msgInfo.setTag(tag);
		// msgInfo.setTopic(topic);
		// msgInfo.setMsgKey(key);
		// msgInfo.setBody(body);
		// insertMessageInfoBO(msgInfo);
		// Object msginfo = SerializeUtils.deserialize(msg.getBody());
		// try {
		// mqc.execute(subExpression, msginfo);
		// updateMessageInfoBO(msgInfo, MqConstants.CONSUMER_STATUS_SUCCESS);
		// ret = Action.CommitMessage;
		// }
		// catch (Exception e) {
		// updateMessageInfoBO(msgInfo, MqConstants.CONSUMER_STATUS_FAILURE);
		// log.error("msgid:[" + msgId + "]topic[" + topic + "]tag[" + tag + "]key[" + key + "] 消费失败……", e);
		// ret = Action.ReconsumeLater;
		// }
		//
		// }
		// catch (Exception e) {
		// log.error("msgid:[" + msgId + "]topic[" + topic + "]tag[" + tag + "]key[" + key + "] 消费失败……", e);
		// ret = Action.ReconsumeLater;
		// }
		//
		// }

		return ret;
	}

	private void updateMessageInfoBO(MessageInfoBO msgInfo, Integer consumerStatus) {

		msgInfo.setConsumerTime(new Date());
		msgInfo.setConsumerStatus(consumerStatus);
		// cacheService.put(MqConstants.MQ_PREFIX + msgInfo.getMsgId(), msgInfo, MqConstants.MQ_EXPIRE);
		// messageInfoService.updateByPrimaryKeySelective(msgInfo);
	}

	private void insertMessageInfoBO(MessageInfoBO msgInfo) {
		msgInfo.setConsumerTime(new Date());
		msgInfo.setConsumerStatus(MqConstants.CONSUMER_STATUS_UPDATE);
		// cacheService.put(MqConstants.MQ_PREFIX + msgInfo.getMsgId(), msgInfo, MqConstants.MQ_EXPIRE);
		// messageInfoService.updateByPrimaryKeySelective(msgInfo);
	}

	public List<MqCunsumer> getMqcList() {
		return mqcList;
	}

	public void setMqcList(List<MqCunsumer> mqcList) {
		this.mqcList = mqcList;
	}

}
