package com.ohaotian.plugin.mq;

import java.util.Date;
import java.util.Properties;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.bo.MessageInfoBO;
import com.ohaotian.plugin.mq.bo.MqConstants;

public class NativeTransOnsProductor implements TransactionProducer {

	/** <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param cacheService
	 * @autho liuce
	 * @time 2016年9月25日 下午2:45:31 */
	public NativeTransOnsProductor(CacheClient cacheService) {
		this.cacheService = cacheService;
	}

	/** 缓存service 用来作为本地模式存放的队列 */
	private CacheClient cacheService;

	private boolean      isStarted;

	@Override
	public boolean isStarted() {
		return isStarted;
	}

	@Override
	public boolean isClosed() {
		return !isStarted();
	}

	@Override
	public void start() {
		this.isStarted = true;
	}

	@Override
	public void updateCredential(Properties properties) {

	}

	@Override
	public void shutdown() {
		this.isStarted = false;
	}

	@Override
	public SendResult send(Message message, LocalTransactionExecuter executer, Object arg) {
		String msgid = "NAV-" + System.nanoTime();
		try {
			message.setMsgID(msgid);
			TransactionStatus status = executer.execute(message, arg);
			if (TransactionStatus.RollbackTransaction == status) {
				// 本地事务显式说明了有异常，此时给应用方返回一个异常。
				throw new RuntimeException("local transaction branch failed ,so transaction rollback");
			}
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}

		SendResult sendResult = new SendResult();
		sendResult.setMessageId(msgid);
		MessageInfoBO msgbo = new MessageInfoBO();

		msgbo.setBody(message.getBody());
		msgbo.setMsgId(msgid);
		msgbo.setTag(message.getTag());
		msgbo.setTopic(message.getTopic());
		msgbo.setMsgKey(message.getKey());
		msgbo.setSendStatus(MqConstants.PRODUCT_SEND_STATUS_SUCCESS);
		msgbo.setSendTime(new Date());

		cacheService.put("LOCALMQ_" + msgid, msgbo);

		return sendResult;
	}

}
