package com.ohaotian.plugin.mq.produce;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.ohaotian.plugin.common.util.SerializeUtils;
import com.ohaotian.plugin.mq.MqMessageListener;
import com.ohaotian.plugin.mq.MqProducerPool;
import com.ohaotian.plugin.mq.util.LogUtils;
import com.taobao.eagleeye.EagleEye;
import org.apache.commons.lang3.StringUtils;

/** <br>
 * 标题: 生产者<br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho liuce
 * @time 2016年8月30日 下午9:47:50 */
public class MqProducer {
	
	// private final static Logger log = LoggerFactory.getLogger(MqProducer.class);

	/** 生产者池 */
	private static MqProducerPool mqProducerPool;

	/** 设置 生产者池
	 * 
	 * @param mqProducerPool
	 *        生产者池 */
	public void setMqProducerPool(MqProducerPool mqProducerPool) {
		MqProducer.mqProducerPool = mqProducerPool;
	}

	/** 发送消息<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param topic
	 * @param tag
	 * @param body
	 * @autho liuce
	 * @time 2016年9月1日 下午11:06:39 */
	public static void sendMsg(String topic, String tag, Object body) {
		topic = mqProducerPool.getPropertyConfigurer().getProperty(topic);

		Message msg = new Message(topic, tag, SerializeUtils.serialize(body));
		// 添加TraceId
		String traceId = getTraceId();
		//这里为了解决消费者里再发消息获取不到traceID的问题用了本地线程变量
		if(StringUtils.isBlank(traceId)){
			traceId = MqMessageListener.traceIds.get();
		}
		
		msg.putUserProperties("TraceId", traceId);
		// 获取生产者
		Producer producer = mqProducerPool.getProducer(topic);
		if (producer == null) {
			producer = mqProducerPool.getSynProducer(topic);
		}

		// 发送事务消息
		producer.send(msg);

		// 打印标准日志
		LogUtils.printMQProducerLog("MqProducer", "sendMsg", msg, body);

	}

	/** <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param topic
	 * @param tag
	 * @param key
	 * @param body
	 * @autho liuce
	 * @time 2017年2月27日 下午5:43:53 */
	public static void sendMsg(String topic, String tag, String key, Object body) {

		topic = mqProducerPool.getPropertyConfigurer().getProperty(topic);

		Message msg = new Message(topic, tag, key, SerializeUtils.serialize(body));
		// 添加TraceId
		String traceId = getTraceId();
		//这里为了解决消费者里再发消息获取不到traceID的问题用了本地线程变量
		if(StringUtils.isBlank(traceId)){
			traceId = MqMessageListener.traceIds.get();
		}
				
		msg.putUserProperties("TraceId", traceId);
		// 获取生产者
		Producer producer = mqProducerPool.getProducer(topic);
		if (producer == null) {
			producer = mqProducerPool.getSynProducer(topic);
		}

		// 发送事务消息
		producer.send(msg);

		// 打印标准日志
		LogUtils.printMQProducerLog("MqProducer", "sendMsg", msg, body);

	}
	private static final String getTraceId() {
		String traceId = EagleEye.getTraceId();
		if (StringUtils.isBlank(traceId)) {
			traceId = "";
		}
		return traceId;
	}

}
