/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.produce;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.ohaotian.plugin.common.util.SerializeUtils;
import com.ohaotian.plugin.mq.MqMessageListener;
import com.ohaotian.plugin.mq.MqProducerPool;
import com.ohaotian.plugin.mq.util.LogUtils;
import com.taobao.eagleeye.EagleEye;
import org.apache.commons.lang3.StringUtils;

public class MqProducer {
    private static MqProducerPool mqProducerPool;

    public void setMqProducerPool(MqProducerPool mqProducerPool) {
        MqProducer.mqProducerPool = mqProducerPool;
    }

    public static void sendMsg(String topic, String tag, Object body) {
        topic = mqProducerPool.getPropertyConfigurer().getProperty(topic);
        Message msg = new Message(topic, tag, SerializeUtils.serialize((Object)body));
        String traceId = MqProducer.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = MqMessageListener.traceIds.get();
        }
        msg.putUserProperties("TraceId", traceId);
        Producer producer = mqProducerPool.getProducer(topic);
        if (producer == null) {
            producer = mqProducerPool.getSynProducer(topic);
        }
        producer.send(msg);
        LogUtils.printMQProducerLog("MqProducer", "sendMsg", msg, body);
    }

    public static void sendMsg(String topic, String tag, String key, Object body) {
        topic = mqProducerPool.getPropertyConfigurer().getProperty(topic);
        Message msg = new Message(topic, tag, key, SerializeUtils.serialize((Object)body));
        String traceId = MqProducer.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = MqMessageListener.traceIds.get();
        }
        msg.putUserProperties("TraceId", traceId);
        Producer producer = mqProducerPool.getProducer(topic);
        if (producer == null) {
            producer = mqProducerPool.getSynProducer(topic);
        }
        producer.send(msg);
        LogUtils.printMQProducerLog("MqProducer", "sendMsg", msg, body);
    }

    private static final String getTraceId() {
        String traceId = EagleEye.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = "";
        }
        return traceId;
    }
}

