/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.bo.MessageInfoBO;
import com.ohaotian.plugin.mq.bo.MqConstants;
import java.util.Date;

public class NativeTransOnsProductor
implements TransactionProducer {
    private CacheClient cacheService;
    private boolean isStarted;

    public NativeTransOnsProductor(CacheClient cacheService) {
        this.cacheService = cacheService;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void start() {
        this.isStarted = true;
    }

    public void shutdown() {
        this.isStarted = false;
    }

    public SendResult send(Message message, LocalTransactionExecuter executer, Object arg) {
        String msgid = "NAV-" + System.nanoTime();
        try {
            message.setMsgID(msgid);
            TransactionStatus status = executer.execute(message, arg);
            if (TransactionStatus.RollbackTransaction == status) {
                throw new RuntimeException("local transaction branch failed ,so transaction rollback");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SendResult sendResult = new SendResult();
        sendResult.setMessageId(msgid);
        MessageInfoBO msgbo = new MessageInfoBO();
        msgbo.setBody(message.getBody());
        msgbo.setMsgId(msgid);
        msgbo.setTag(message.getTag());
        msgbo.setTopic(message.getTopic());
        msgbo.setMsgKey(message.getKey());
        msgbo.setSendStatus(MqConstants.PRODUCT_SEND_STATUS_SUCCESS);
        msgbo.setSendTime(new Date());
        this.cacheService.put("LOCALMQ_" + msgid, (Object)msgbo);
        return sendResult;
    }
}

