/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.nosql.es.strategy;

import com.ohaotian.plugin.nosql.bo.NosqlQueryBO;
import com.ohaotian.plugin.nosql.constant.NosqlConnetType;
import com.ohaotian.plugin.nosql.constant.NosqlNestedType;
import com.ohaotian.plugin.nosql.constant.NosqlQueryType;
import com.ohaotian.plugin.nosql.es.strategy.EsQueryBoolQueryTypeStrategy;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.springframework.util.CollectionUtils;

public class EsQueryBoolQueryTypeStrategyImpl
implements EsQueryBoolQueryTypeStrategy {
    @Override
    public void buildQuery(NosqlQueryBO nosqlQueryBO, BoolQueryBuilder boolQueryBuilder) {
        if (NosqlQueryType.ACCURATE.equals((Object)nosqlQueryBO.getQueryType())) {
            if (StringUtils.isNotBlank((String)nosqlQueryBO.getFieldName()) && StringUtils.isNotBlank((String)nosqlQueryBO.getFieldValue())) {
                this.buildQueryForSingleAccurate(boolQueryBuilder, nosqlQueryBO.getFieldName(), nosqlQueryBO.getFieldValue(), nosqlQueryBO.getConnetType(), nosqlQueryBO.getNestedType());
            } else if (StringUtils.isNotBlank((String)nosqlQueryBO.getFieldName()) && !CollectionUtils.isEmpty(nosqlQueryBO.getFieldValueList())) {
                this.buildQueryForListAccurate(boolQueryBuilder, nosqlQueryBO.getFieldName(), nosqlQueryBO.getFieldValueList(), nosqlQueryBO.getConnetType(), nosqlQueryBO.getNestedType());
            }
        } else if (NosqlQueryType.WILD_CARD.equals((Object)nosqlQueryBO.getQueryType())) {
            if (StringUtils.isNotBlank((String)nosqlQueryBO.getFieldName()) && StringUtils.isNotBlank((String)nosqlQueryBO.getFieldValue())) {
                this.buildQueryForSingleWildcard(boolQueryBuilder, nosqlQueryBO.getFieldName(), nosqlQueryBO.getFieldValue(), nosqlQueryBO.getConnetType(), nosqlQueryBO.getNestedType());
            } else if (StringUtils.isNotBlank((String)nosqlQueryBO.getFieldName()) && !CollectionUtils.isEmpty(nosqlQueryBO.getFieldValueList())) {
                this.buildQueryForListWildcard(boolQueryBuilder, nosqlQueryBO.getFieldName(), nosqlQueryBO.getFieldValueList(), nosqlQueryBO.getConnetType(), nosqlQueryBO.getNestedType());
            }
        } else if (NosqlQueryType.RANGE.equals((Object)nosqlQueryBO.getQueryType())) {
            if (StringUtils.isNotBlank((String)nosqlQueryBO.getCreateFieldValue()) || StringUtils.isNotBlank((String)nosqlQueryBO.getEndFieldValue())) {
                this.buildQueryForRange(boolQueryBuilder, nosqlQueryBO.getFieldName(), nosqlQueryBO.getCreateFieldValue(), nosqlQueryBO.getEndFieldValue(), nosqlQueryBO.getConnetType(), nosqlQueryBO.getNestedType());
            } else if (nosqlQueryBO.getCreateFieldDate() != null || nosqlQueryBO.getEndFieldDate() != null) {
                this.buildQueryForRangeDate(boolQueryBuilder, nosqlQueryBO.getFieldName(), nosqlQueryBO.getCreateFieldDate(), nosqlQueryBO.getEndFieldDate(), nosqlQueryBO.getConnetType(), nosqlQueryBO.getNestedType());
            }
        } else if (NosqlQueryType.NULL.equals((Object)nosqlQueryBO.getQueryType())) {
            this.buildQueryForNull(boolQueryBuilder, nosqlQueryBO.getFieldName(), nosqlQueryBO.getConnetType(), nosqlQueryBO.getNestedType());
        } else if (NosqlQueryType.NOT_NULL.equals((Object)nosqlQueryBO.getQueryType())) {
            this.buildQueryForNotNull(boolQueryBuilder, nosqlQueryBO.getFieldName(), nosqlQueryBO.getConnetType(), nosqlQueryBO.getNestedType());
        }
    }

    @Override
    public void buildQueryForSingleAccurate(BoolQueryBuilder boolQueryBuilder, String fieldName, String fieldValue, NosqlConnetType connetType, NosqlNestedType nestedType) {
        if (NosqlNestedType.LIST.equals((Object)nestedType)) {
            String nestedPath = "";
            nestedPath = fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName;
            NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)fieldValue), (ScoreMode)ScoreMode.Avg);
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)nestedQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)nestedQuery);
            }
        } else if (NosqlConnetType.AND.equals((Object)connetType)) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)fieldValue));
        } else {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)fieldValue));
        }
    }

    @Override
    public void buildQueryForSingleWildcard(BoolQueryBuilder boolQueryBuilder, String fieldName, String fieldValue, NosqlConnetType connetType, NosqlNestedType nestedType) {
        if (NosqlNestedType.LIST.equals((Object)nestedType)) {
            String nestedPath = "";
            nestedPath = fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName;
            NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)QueryBuilders.wildcardQuery((String)fieldName, (String)("*" + fieldValue + "*")), (ScoreMode)ScoreMode.Avg);
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)nestedQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)nestedQuery);
            }
        } else if (NosqlConnetType.AND.equals((Object)connetType)) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)fieldName, (String)("*" + fieldValue + "*")));
        } else {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)fieldName, (String)("*" + fieldValue + "*")));
        }
    }

    @Override
    public void buildQueryForListAccurate(BoolQueryBuilder boolQueryBuilder, String fieldName, List<String> fieldValueList, NosqlConnetType connetType, NosqlNestedType nestedType) {
        if (NosqlNestedType.LIST.equals((Object)nestedType)) {
            String nestedPath = "";
            nestedPath = fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName;
            NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)QueryBuilders.termsQuery((String)fieldName, fieldValueList), (ScoreMode)ScoreMode.Avg);
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)nestedQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)nestedQuery);
            }
        } else if (NosqlConnetType.AND.equals((Object)connetType)) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)fieldName, fieldValueList));
        } else {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)fieldName, fieldValueList));
        }
    }

    @Override
    public void buildQueryForListWildcard(BoolQueryBuilder boolQueryBuilder, String fieldName, List<String> fieldValueList, NosqlConnetType connetType, NosqlNestedType nestedType) {
        if (NosqlNestedType.LIST.equals((Object)nestedType)) {
            String nestedPath = "";
            nestedPath = fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName;
            BoolQueryBuilder nestedBoolQuery = new BoolQueryBuilder();
            for (String value : fieldValueList) {
                nestedBoolQuery.should((QueryBuilder)QueryBuilders.wildcardQuery((String)fieldName, (String)("*" + value + "*")));
            }
            NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)nestedBoolQuery, (ScoreMode)ScoreMode.Avg);
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)nestedQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)nestedQuery);
            }
        } else {
            BoolQueryBuilder innerBoolQuery = new BoolQueryBuilder();
            for (String fieldValue : fieldValueList) {
                innerBoolQuery.should((QueryBuilder)QueryBuilders.wildcardQuery((String)fieldName, (String)fieldValue));
            }
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)innerBoolQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)innerBoolQuery);
            }
        }
    }

    @Override
    public void buildQueryForRange(BoolQueryBuilder boolQueryBuilder, String fieldName, String createFieldValue, String endFieldValue, NosqlConnetType connetType, NosqlNestedType nestedType) {
        if (NosqlNestedType.LIST.equals((Object)nestedType)) {
            String nestedPath = fieldName;
            int dotIndex = fieldName.indexOf(".");
            if (dotIndex > 0) {
                nestedPath = fieldName.substring(0, dotIndex);
            }
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)fieldName);
            if (StringUtils.isNotBlank((String)createFieldValue)) {
                rangeQuery.gte((Object)createFieldValue);
            }
            if (StringUtils.isNotBlank((String)endFieldValue)) {
                rangeQuery.lte((Object)endFieldValue);
            }
            NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)rangeQuery, (ScoreMode)ScoreMode.Avg);
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)nestedQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)nestedQuery);
            }
        } else {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)fieldName);
            if (StringUtils.isNotBlank((String)createFieldValue)) {
                rangeQueryBuilder.gte((Object)createFieldValue);
            }
            if (StringUtils.isNotBlank((String)endFieldValue)) {
                rangeQueryBuilder.lte((Object)endFieldValue);
            }
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
            } else {
                boolQueryBuilder.should((QueryBuilder)rangeQueryBuilder);
            }
        }
    }

    @Override
    public void buildQueryForRangeDate(BoolQueryBuilder boolQueryBuilder, String fieldName, Date createFieldDate, Date endFieldDate, NosqlConnetType connetType, NosqlNestedType nestedType) {
        if (NosqlNestedType.LIST.equals((Object)nestedType)) {
            String nestedPath = fieldName;
            int dotIndex = fieldName.indexOf(".");
            if (dotIndex > 0) {
                nestedPath = fieldName.substring(0, dotIndex);
            }
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)fieldName);
            if (createFieldDate != null) {
                rangeQuery.gte((Object)createFieldDate.getTime());
            }
            if (endFieldDate != null) {
                rangeQuery.lte((Object)endFieldDate.getTime());
            }
            NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)rangeQuery, (ScoreMode)ScoreMode.Avg);
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)nestedQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)nestedQuery);
            }
        } else {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)fieldName);
            if (createFieldDate != null) {
                rangeQueryBuilder.gte((Object)createFieldDate.getTime());
            }
            if (endFieldDate != null) {
                rangeQueryBuilder.lte((Object)endFieldDate.getTime());
            }
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
            } else {
                boolQueryBuilder.should((QueryBuilder)rangeQueryBuilder);
            }
        }
    }

    @Override
    public void buildQueryForNull(BoolQueryBuilder boolQueryBuilder, String fieldName, NosqlConnetType connetType, NosqlNestedType nestedType) {
        if (NosqlNestedType.LIST.equals((Object)nestedType)) {
            String nestedPath = fieldName;
            int dotIndex = fieldName.indexOf(".");
            if (dotIndex > 0) {
                nestedPath = fieldName.substring(0, dotIndex);
            }
            NestedQueryBuilder isEmptyQuery = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)fieldName)), (ScoreMode)ScoreMode.None);
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)isEmptyQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)isEmptyQuery);
            }
        } else {
            BoolQueryBuilder isEmptyQuery = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)fieldName));
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)isEmptyQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)isEmptyQuery);
            }
        }
    }

    @Override
    public void buildQueryForNotNull(BoolQueryBuilder boolQueryBuilder, String fieldName, NosqlConnetType connetType, NosqlNestedType nestedType) {
        if (NosqlNestedType.LIST.equals((Object)nestedType)) {
            String nestedPath = fieldName;
            int dotIndex = fieldName.indexOf(".");
            if (dotIndex > 0) {
                nestedPath = fieldName.substring(0, dotIndex);
            }
            NestedQueryBuilder isNotEmptyQuery = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)QueryBuilders.existsQuery((String)fieldName), (ScoreMode)ScoreMode.None);
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)isNotEmptyQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)isNotEmptyQuery);
            }
        } else {
            ExistsQueryBuilder isNotEmptyQuery = QueryBuilders.existsQuery((String)fieldName);
            if (NosqlConnetType.AND.equals((Object)connetType)) {
                boolQueryBuilder.must((QueryBuilder)isNotEmptyQuery);
            } else {
                boolQueryBuilder.should((QueryBuilder)isNotEmptyQuery);
            }
        }
    }
}

