/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.nosql.impl;

import com.ohaotian.plugin.nosql.bo.NosqlGroupBO;
import com.ohaotian.plugin.nosql.bo.NosqlOrderBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryGroupBO;
import com.ohaotian.plugin.nosql.constant.NosqlConnetType;
import com.ohaotian.plugin.nosql.constant.NosqlSortOrder;
import com.ohaotian.plugin.nosql.impl.NosqlBuilder;
import java.util.ArrayList;
import java.util.List;

public class NosqlCreateBuilder {
    private NosqlBuilder nosqlBuilder = new NosqlBuilder();
    private List<NosqlOrderBO> nosqlOrderList = new ArrayList<NosqlOrderBO>();
    private List<NosqlGroupBO> nosqlGroupList = new ArrayList<NosqlGroupBO>();
    private List<NosqlQueryGroupBO> nosqlQueryGroupList = new ArrayList<NosqlQueryGroupBO>();

    public NosqlBuilder queryGroup(List<NosqlQueryBO> nosqlQueryBO) {
        return this.queryGroup(nosqlQueryBO, NosqlConnetType.AND);
    }

    public NosqlBuilder queryGroup(List<NosqlQueryBO> nosqlQueryBO, NosqlConnetType connetType) {
        NosqlQueryGroupBO nosqlQueryGroupBO = new NosqlQueryGroupBO();
        nosqlQueryGroupBO.setNosqlQueryList(nosqlQueryBO);
        nosqlQueryGroupBO.setConnetType(connetType);
        this.nosqlQueryGroupList.add(nosqlQueryGroupBO);
        this.nosqlBuilder.setNosqlQueryGroupList(this.nosqlQueryGroupList);
        return this.nosqlBuilder;
    }

    public NosqlBuilder pageNo(Integer pageNo) {
        this.nosqlBuilder.setPageNo(pageNo);
        return this.nosqlBuilder;
    }

    public NosqlBuilder pageSize(Integer pageSize) {
        this.nosqlBuilder.setPageSize(pageSize);
        return this.nosqlBuilder;
    }

    public NosqlBuilder orderBy(String fieldName, NosqlSortOrder order) {
        NosqlOrderBO nosqlOrderBO = new NosqlOrderBO();
        nosqlOrderBO.setFieldName(fieldName);
        nosqlOrderBO.setSortOrder(order);
        this.nosqlOrderList.add(nosqlOrderBO);
        this.nosqlBuilder.setNosqlOrderList(this.nosqlOrderList);
        return this.nosqlBuilder;
    }

    public NosqlBuilder groupBy(String fieldName) {
        return this.groupBy(fieldName, true, false);
    }

    public NosqlBuilder groupBy(String fieldName, boolean key) {
        return this.groupBy(fieldName, key, false);
    }

    public NosqlBuilder groupBy(String fieldName, boolean key, boolean count) {
        NosqlGroupBO nosqlGroupBO = new NosqlGroupBO();
        nosqlGroupBO.setFieldName(fieldName);
        nosqlGroupBO.setCount(count);
        nosqlGroupBO.setKey(key);
        this.nosqlGroupList.add(nosqlGroupBO);
        this.nosqlBuilder.setNosqlOrderList(this.nosqlOrderList);
        return this.nosqlBuilder;
    }

    public NosqlBuilder build() {
        return this.nosqlBuilder;
    }
}

