/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.nosql.es;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.nosql.NosqlManager;
import com.ohaotian.plugin.nosql.bo.NosqlOrderBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryAggBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryGroupBO;
import com.ohaotian.plugin.nosql.constant.NosqlAggType;
import com.ohaotian.plugin.nosql.constant.NosqlConnetType;
import com.ohaotian.plugin.nosql.constant.NosqlSortOrder;
import com.ohaotian.plugin.nosql.es.strategy.EsQueryBoolQueryTypeStrategyImpl;
import com.ohaotian.plugin.nosql.impl.NosqlBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EsManagerImpl
implements NosqlManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EsManagerImpl.class);
    private static RequestOptions options = RequestOptions.DEFAULT;
    private RestHighLevelClient client;
    private static ObjectMapper mapper;
    private static final int batchSize = 1000;
    private static final int NUMBER_OF_RETRY = 3;

    @Override
    public NosqlQueryByBuilderRsqBO queryForBuilder(String index, NosqlBuilder nosqlBuilder) {
        NosqlQueryByBuilderRsqBO rsqBO = new NosqlQueryByBuilderRsqBO();
        try {
            Integer pageNo = nosqlBuilder.getPageNo();
            Integer pageSize = nosqlBuilder.getPageSize();
            SearchRequest searchRequest = new SearchRequest(new String[]{index});
            SearchSourceBuilder sourceBuilder = this.buildSearchRequest(index, nosqlBuilder);
            String jsonSource = sourceBuilder.toString();
            rsqBO.setJsonSource(jsonSource);
            searchRequest.source(sourceBuilder);
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            long totalHitsValue = 0L;
            ArrayList<Map> documents = new ArrayList<Map>();
            if (hits != null) {
                long l = totalHitsValue = hits.getTotalHits() != null ? hits.getTotalHits().value : 0L;
                if (totalHitsValue > 0L) {
                    for (SearchHit hit : hits.getHits()) {
                        if (hit == null || hit.getSourceAsMap() == null) continue;
                        documents.add(hit.getSourceAsMap());
                    }
                }
            }
            int totalPages = 0;
            if (pageSize > 0) {
                totalPages = (int)Math.ceil((double)totalHitsValue / (double)pageSize.intValue());
            }
            String resultStr = documents.isEmpty() ? "[]" : JSON.toJSONString(documents);
            rsqBO.setDocumentStr(resultStr);
            rsqBO.setTotal(totalPages);
            rsqBO.setRecordsTotal((int)totalHitsValue);
            rsqBO.setPageNo(pageNo);
            rsqBO.setPageSize(pageSize);
        }
        catch (Exception e) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc(e.getMessage());
            e.printStackTrace();
        }
        return rsqBO;
    }

    private SearchSourceBuilder buildSearchRequest(String index, NosqlBuilder nosqlBuilder) throws IOException {
        Integer pageNo = nosqlBuilder.getPageNo();
        Integer pageSize = nosqlBuilder.getPageSize();
        int from = (pageNo - 1) * pageSize;
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder = this.parseQueryGroup(boolQueryBuilder, nosqlBuilder.getNosqlQueryGroupList(), index);
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        for (NosqlOrderBO nosqlOrderBO : nosqlBuilder.getNosqlOrderList()) {
            boolean isKeyword;
            if (!StringUtils.isNotBlank((CharSequence)nosqlOrderBO.getFieldName())) continue;
            if (StringUtils.isNotBlank((CharSequence)nosqlOrderBO.getFieldName()) && !nosqlOrderBO.getFieldName().endsWith(".keyword") && (isKeyword = this.isKeywordField(index, nosqlOrderBO.getFieldName()))) {
                nosqlOrderBO.setFieldName(nosqlOrderBO.getFieldName() + ".keyword");
            }
            FieldSortBuilder fieldSortBuilder = new FieldSortBuilder(nosqlOrderBO.getFieldName());
            if (NosqlSortOrder.ASC.equals((Object)nosqlOrderBO.getSortOrder())) {
                fieldSortBuilder.order(SortOrder.ASC);
            } else {
                fieldSortBuilder.order(SortOrder.DESC);
            }
            sourceBuilder.sort((SortBuilder)fieldSortBuilder);
        }
        sourceBuilder.from(from);
        sourceBuilder.size(pageSize.intValue());
        sourceBuilder.trackTotalHits(true);
        return sourceBuilder;
    }

    private BoolQueryBuilder parseQueryGroup(BoolQueryBuilder boolQueryBuilder, List<NosqlQueryGroupBO> nosqlQueryGroupList, String index) throws IOException {
        EsQueryBoolQueryTypeStrategyImpl esQueryBoolQueryTypeStrategy = new EsQueryBoolQueryTypeStrategyImpl();
        for (NosqlQueryGroupBO nosqlQueryGroupBO : nosqlQueryGroupList) {
            BoolQueryBuilder innerBoolQuery = new BoolQueryBuilder();
            Object finalQuery = StringUtils.isNotBlank((CharSequence)nosqlQueryGroupBO.getNestedPath()) ? new NestedQueryBuilder(nosqlQueryGroupBO.getNestedPath(), (QueryBuilder)innerBoolQuery, ScoreMode.Avg) : innerBoolQuery;
            if (!CollectionUtils.isEmpty(nosqlQueryGroupBO.getNosqlQueryGroupList())) {
                this.parseQueryGroup(innerBoolQuery, nosqlQueryGroupBO.getNosqlQueryGroupList(), index);
                if (NosqlConnetType.AND.equals((Object)nosqlQueryGroupBO.getConnetType())) {
                    boolQueryBuilder.must((QueryBuilder)finalQuery);
                    continue;
                }
                if (NosqlConnetType.OR.equals((Object)nosqlQueryGroupBO.getConnetType())) {
                    boolQueryBuilder.should((QueryBuilder)finalQuery);
                    continue;
                }
                if (!NosqlConnetType.NOT.equals((Object)nosqlQueryGroupBO.getConnetType())) continue;
                boolQueryBuilder.mustNot((QueryBuilder)finalQuery);
                continue;
            }
            for (NosqlQueryBO nosqlQueryBO : nosqlQueryGroupBO.getNosqlQueryList()) {
                boolean isKeyword;
                if (StringUtils.isNotBlank((CharSequence)nosqlQueryBO.getFieldName()) && !nosqlQueryBO.getFieldName().endsWith(".keyword") && (isKeyword = this.isKeywordField(index, nosqlQueryBO.getFieldName()))) {
                    nosqlQueryBO.setFieldName(nosqlQueryBO.getFieldName() + ".keyword");
                }
                esQueryBoolQueryTypeStrategy.buildQuery(nosqlQueryBO, innerBoolQuery);
            }
            if (NosqlConnetType.AND.equals((Object)nosqlQueryGroupBO.getConnetType())) {
                boolQueryBuilder.must((QueryBuilder)finalQuery);
                continue;
            }
            if (NosqlConnetType.OR.equals((Object)nosqlQueryGroupBO.getConnetType())) {
                boolQueryBuilder.should((QueryBuilder)finalQuery);
                continue;
            }
            if (!NosqlConnetType.NOT.equals((Object)nosqlQueryGroupBO.getConnetType())) continue;
            boolQueryBuilder.mustNot((QueryBuilder)finalQuery);
        }
        return boolQueryBuilder;
    }

    public boolean isKeywordField(String index, String fieldName) throws IOException {
        FieldCapabilitiesRequest request = new FieldCapabilitiesRequest().indices(new String[]{index}).fields(new String[]{fieldName, fieldName + ".keyword"});
        FieldCapabilitiesResponse response = this.client.fieldCaps(request, RequestOptions.DEFAULT);
        Map fieldCaps = response.getField(fieldName);
        if (fieldCaps != null && fieldCaps.get("keyword") != null) {
            return true;
        }
        Map keywordFieldCaps = response.getField(fieldName + ".keyword");
        return keywordFieldCaps != null && keywordFieldCaps.get("keyword") != null;
    }

    private String extractFieldType(Map<String, Object> sourceMap, String fieldName) {
        Map fieldProperties;
        Map properties = (Map)sourceMap.get("properties");
        if (properties != null && (fieldProperties = (Map)properties.get(fieldName)) != null) {
            return (String)fieldProperties.get("type");
        }
        return null;
    }

    @Override
    public NosqlQueryByBuilderRsqBO aggregateByFields(String index, NosqlBuilder nosqlBuilder) throws IOException {
        NosqlQueryByBuilderRsqBO rsqBO = new NosqlQueryByBuilderRsqBO();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{index});
            SearchSourceBuilder sourceBuilder = this.buildSearchRequest(index, nosqlBuilder);
            List<NosqlQueryAggBO> aggList = nosqlBuilder.getNosqlQueryAggList();
            NosqlQueryAggBO groupAgg = nosqlBuilder.getNosqlQueryAggList().get(0);
            if (groupAgg.getAggType() != NosqlAggType.TERMS) {
                throw new IllegalArgumentException("\u7b2c\u4e00\u4e2a\u805a\u5408\u5fc5\u987b\u662f TERMS \u7c7b\u578b\u7528\u4e8e\u5206\u7ec4");
            }
            Integer pageNo = nosqlBuilder.getPageNo();
            Integer pageSize = nosqlBuilder.getPageSize();
            int maxShardSize = 10000;
            int shardSize = Math.min(maxShardSize, pageSize * pageNo);
            TermsAggregationBuilder groupAggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)("group_by_" + groupAgg.getFieldName())).field(groupAgg.getFieldName())).size(shardSize);
            if (groupAgg.getNosqlOrderList() != null && !groupAgg.getNosqlOrderList().isEmpty()) {
                for (NosqlOrderBO nosqlOrderBO : groupAgg.getNosqlOrderList()) {
                    boolean isKeyword;
                    if (!StringUtils.isNotBlank((CharSequence)nosqlOrderBO.getFieldName())) continue;
                    boolean ascFlag = NosqlSortOrder.ASC.equals((Object)nosqlOrderBO.getSortOrder());
                    if (StringUtils.isNotBlank((CharSequence)nosqlOrderBO.getFieldName()) && !nosqlOrderBO.getFieldName().endsWith(".keyword") && (isKeyword = this.isKeywordField(index, nosqlOrderBO.getFieldName()))) {
                        nosqlOrderBO.setFieldName(nosqlOrderBO.getFieldName() + ".keyword");
                    }
                    String avgName = "avg_" + nosqlOrderBO.getFieldName().replace(".", "_");
                    groupAggregation.order(BucketOrder.aggregation((String)avgName, (boolean)ascFlag));
                    AvgAggregationBuilder avgCreateTimeAggregation = (AvgAggregationBuilder)AggregationBuilders.avg((String)avgName).field(nosqlOrderBO.getFieldName());
                    groupAggregation.subAggregation((AggregationBuilder)avgCreateTimeAggregation);
                }
            }
            TopHitsAggregationBuilder detailAggregation = AggregationBuilders.topHits((String)"aggList").size(1000);
            if (nosqlBuilder.getNosqlOrderList() != null && !nosqlBuilder.getNosqlOrderList().isEmpty()) {
                for (NosqlOrderBO orderBO : nosqlBuilder.getNosqlOrderList()) {
                    boolean isKeyword;
                    SortOrder sortOrder;
                    if (!StringUtils.isNotBlank((CharSequence)orderBO.getFieldName())) continue;
                    SortOrder sortOrder2 = sortOrder = NosqlSortOrder.ASC.equals((Object)orderBO.getSortOrder()) ? SortOrder.ASC : SortOrder.DESC;
                    if (StringUtils.isNotBlank((CharSequence)orderBO.getFieldName()) && !orderBO.getFieldName().endsWith(".keyword") && (isKeyword = this.isKeywordField(index, orderBO.getFieldName()))) {
                        orderBO.setFieldName(orderBO.getFieldName() + ".keyword");
                    }
                    detailAggregation.sort(orderBO.getFieldName(), sortOrder);
                }
            }
            CardinalityAggregationBuilder cardinalityAggregationBuilder = (CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)"unique_values_count").field(groupAgg.getFieldName());
            groupAggregation.subAggregation((AggregationBuilder)detailAggregation);
            sourceBuilder.aggregation((AggregationBuilder)groupAggregation);
            sourceBuilder.aggregation((AggregationBuilder)cardinalityAggregationBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            String jsonSource = sourceBuilder.toString();
            rsqBO.setJsonSource(jsonSource);
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            Cardinality uniqueValuesCount = (Cardinality)searchResponse.getAggregations().get("unique_values_count");
            long totalHitsValue = uniqueValuesCount.getValue();
            int totalPages = (int)Math.ceil((double)totalHitsValue / (double)pageSize.intValue());
            List<Map<String, Object>> documents = this.processAggregationResultsWithPagination(searchResponse.getAggregations(), aggList, pageNo, pageSize);
            String resultStr = documents.isEmpty() ? "[]" : JSON.toJSONString(documents, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            rsqBO.setDocumentStr(resultStr);
            rsqBO.setTotal(totalPages);
            rsqBO.setRecordsTotal((int)totalHitsValue);
            rsqBO.setPageNo(pageNo);
            rsqBO.setPageSize(pageSize);
        }
        catch (Exception e) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc(e.getMessage());
            e.printStackTrace();
        }
        return rsqBO;
    }

    private List<Map<String, Object>> processAggregationResultsWithPagination(Aggregations aggregations, List<NosqlQueryAggBO> aggList, int pageNo, int pageSize) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (aggregations == null || aggList.isEmpty()) {
            return results;
        }
        NosqlQueryAggBO currentAgg = aggList.get(0);
        String aggName = "group_by_" + currentAgg.getFieldName();
        Terms terms = (Terms)aggregations.get(aggName);
        if (terms != null) {
            List buckets = terms.getBuckets();
            int startIndex = (pageNo - 1) * pageSize;
            int endIndex = Math.min(startIndex + pageSize, buckets.size());
            for (int i = startIndex; i < endIndex; ++i) {
                Terms.Bucket bucket = (Terms.Bucket)buckets.get(i);
                HashMap<String, List<Object>> item = new HashMap<String, List<Object>>();
                TopHits topHits = (TopHits)bucket.getAggregations().get("aggList");
                if (topHits != null) {
                    SearchHits searchHits = topHits.getHits();
                    if (searchHits.getTotalHits().value > 0L) {
                        SearchHit firstHit = searchHits.getAt(0);
                        Map sourceAsMap = firstHit.getSourceAsMap();
                        item.putAll(sourceAsMap);
                    }
                    ArrayList<Map> details = new ArrayList<Map>();
                    for (SearchHit hit : searchHits) {
                        Map sourceAsMap = hit.getSourceAsMap();
                        details.add(sourceAsMap);
                    }
                    item.put("aggList", details);
                }
                if (aggList.size() > 1) {
                    List<Map<String, Object>> subResults = this.processAggregationResults(bucket.getAggregations(), aggList.subList(1, aggList.size()));
                    item.put("sub_aggregations", subResults);
                }
                results.add(item);
            }
        }
        return results;
    }

    private List<Map<String, Object>> processAggregationResults(Aggregations aggregations, List<NosqlQueryAggBO> aggList) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (aggregations == null || aggList.isEmpty()) {
            return results;
        }
        NosqlQueryAggBO currentAgg = aggList.get(0);
        String aggName = "group_by_" + currentAgg.getFieldName();
        Terms terms = (Terms)aggregations.get(aggName);
        if (terms != null) {
            for (Terms.Bucket bucket : terms.getBuckets()) {
                HashMap<String, List<Object>> item = new HashMap<String, List<Object>>();
                TopHits topHits = (TopHits)bucket.getAggregations().get("aggList");
                if (topHits != null) {
                    SearchHits searchHits = topHits.getHits();
                    if (searchHits.getTotalHits().value > 0L) {
                        SearchHit firstHit = searchHits.getAt(0);
                        Map sourceAsMap = firstHit.getSourceAsMap();
                        item.putAll(sourceAsMap);
                    }
                    ArrayList<Map> details = new ArrayList<Map>();
                    for (SearchHit hit : searchHits) {
                        Map sourceAsMap = hit.getSourceAsMap();
                        details.add(sourceAsMap);
                    }
                    item.put("aggList", details);
                }
                if (aggList.size() > 1) {
                    List<Map<String, Object>> subResults = this.processAggregationResults(bucket.getAggregations(), aggList.subList(1, aggList.size()));
                    item.put("sub_aggregations", subResults);
                }
                results.add(item);
            }
        }
        return results;
    }

    @Override
    public NosqlQueryByBuilderRsqBO queryAll(String index, int pageNo, int pageSize) throws IOException {
        NosqlQueryByBuilderRsqBO rsqBO = new NosqlQueryByBuilderRsqBO();
        int from = (pageNo - 1) * pageSize;
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        sourceBuilder.from(from);
        sourceBuilder.size(pageSize);
        searchRequest.source(sourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = searchResponse.getHits();
        long totalHitsValue = 0L;
        ArrayList<Map> documents = new ArrayList<Map>();
        if (hits != null) {
            long l = totalHitsValue = hits.getTotalHits() != null ? hits.getTotalHits().value : 0L;
            if (totalHitsValue > 0L) {
                for (SearchHit hit : hits.getHits()) {
                    if (hit == null || hit.getSourceAsMap() == null) continue;
                    documents.add(hit.getSourceAsMap());
                }
            }
        }
        int totalPages = (int)Math.ceil((double)totalHitsValue / (double)pageSize);
        String resultStr = documents.isEmpty() ? "[]" : JSON.toJSONString(documents);
        rsqBO.setDocumentStr(resultStr);
        rsqBO.setTotal(totalPages);
        rsqBO.setRecordsTotal((int)totalHitsValue);
        rsqBO.setPageNo(pageNo);
        rsqBO.setPageSize(pageSize);
        return rsqBO;
    }

    private List<Map<String, Object>> extractDocuments(SearchResponse searchResponse) {
        return Arrays.stream(searchResponse.getHits().getHits()).map(hit -> hit.getSourceAsMap()).collect(Collectors.toList());
    }

    @Override
    public String addData(String index, String id, JSONObject object) {
        try {
            String jsonString = JSON.toJSONString((Object)object);
            Request request = new Request("PUT", "/" + index + "/_doc/" + (id != null ? id : ""));
            request.setJsonEntity(jsonString);
            int maxRetries = 3;
            Response response = null;
            for (int retryCount = 0; retryCount < maxRetries; ++retryCount) {
                try {
                    response = this.getLowLevelClient().performRequest(request);
                    break;
                }
                catch (IOException e) {
                    if (e.getMessage().contains("Connection reset by peer")) {
                        LOGGER.error("\u51fa\u73b0Connection reset by peer\u5f02\u5e38\uff0c\u91cd\u8bd5\u7b2c{}\u6b21", (Object)(retryCount + 1));
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            LOGGER.error("\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38\uff1a", (Throwable)ie);
                            break;
                        }
                    }
                    LOGGER.error("\u8bf7\u6c42\u5931\u8d25\uff1a", (Throwable)e);
                    throw new Exception("\u8bf7\u6c42\u5931\u8d25", e);
                }
                catch (Exception e) {
                    LOGGER.error("\u8bf7\u6c42\u5931\u8d25\uff1a", (Throwable)e);
                    throw new Exception("\u8bf7\u6c42\u5931\u8d25", e);
                }
            }
            if (response == null) {
                throw new Exception("\u8bf7\u6c42\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570\u8fbe\u5230\u4e0a\u9650");
            }
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201) {
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                return id != null ? id : responseBody;
            }
            LOGGER.info("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + response.getStatusLine().getStatusCode());
        }
        catch (Exception e) {
            LOGGER.info("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    @Override
    public void addBatch(String index, List<Map<String, JSONObject>> list) {
        if (list.isEmpty()) {
            return;
        }
        int pages = (int)Math.ceil((double)list.size() / 1000.0);
        for (int i = 0; i < pages; ++i) {
            List<Map<String, JSONObject>> subList = this.subList(list, 1000, i);
            this.dealBatch(index, subList);
            LOGGER.info("\u6279\u91cf\u5904\u7406\u7b2c--" + i + "\u6b21,\u5171\u8ba1:" + subList.size() + "--\u6761...");
        }
        LOGGER.info("\u63d2\u5165\u5b8c\u6bd5\uff0c\u5171\u8ba1:" + list.size() + "--\u6761...");
    }

    public List<Map<String, JSONObject>> subList(List<Map<String, JSONObject>> dataList, int pageSize, int currentPage) {
        ArrayList<Map<String, JSONObject>> currentPageList = new ArrayList<Map<String, JSONObject>>();
        if (dataList != null && dataList.size() > 0) {
            int currIdx = currentPage > 0 ? currentPage * pageSize : 0;
            for (int i = 0; i < pageSize && i < dataList.size() - currIdx; ++i) {
                Map<String, JSONObject> map = dataList.get(currIdx + i);
                currentPageList.add(map);
            }
        }
        return currentPageList;
    }

    private void dealBatch(String index, List<Map<String, JSONObject>> list) {
        BulkRequest request = new BulkRequest();
        list.forEach(map -> {
            for (Map.Entry entry : map.entrySet()) {
                IndexRequest indexRequest = new IndexRequest();
                indexRequest.index(index);
                indexRequest.id((String)entry.getKey());
                try {
                    indexRequest.source(mapper.writeValueAsString(entry.getValue()), XContentType.JSON);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                request.add(indexRequest);
            }
        });
        try {
            BulkResponse responses = this.client.bulk(request, options);
            if (responses.hasFailures()) {
                LOGGER.info("\u6279\u91cf\u63d2\u5165\u6709\u5931\u8d25\u6570\u636e!");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u54c1\u4fe1\u606f\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public Boolean deleteDataByCondition(String endPoint, JSONObject qryJson) {
        boolean deleteResult = false;
        NStringEntity entity = new NStringEntity(qryJson.toJSONString(), ContentType.APPLICATION_JSON);
        try {
            JSONObject deleteResultJson;
            int deleteCount;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotBlank((CharSequence)result) && (deleteCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("deleted").intValue()) > 0) {
                deleteResult = true;
            }
        }
        catch (IOException e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return deleteResult;
    }

    @Override
    public Boolean updateData(String index, String id, JSONObject qryJson) throws Exception {
        boolean deleteResult = true;
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.index(index);
        indexRequest.id(id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)qryJson), XContentType.JSON);
            UpdateRequest updateRequest = new UpdateRequest();
            updateRequest.index(index);
            updateRequest.id(id);
            updateRequest.doc(indexRequest);
            UpdateResponse rspose = this.client.update(updateRequest, options);
            LOGGER.info(JSONObject.toJSONString((Object)rspose));
        }
        catch (Exception e) {
            if (e.getMessage().contains("Connection reset by peer")) {
                LOGGER.error("\u51fa\u73b0Connection reset by peer\u5f02\u5e38\uff0c\u91cd\u8bd51\u6b21");
                try {
                    Thread.sleep(1000L);
                    indexRequest.source(mapper.writeValueAsString((Object)qryJson), XContentType.JSON);
                    UpdateRequest updateRequest = new UpdateRequest();
                    updateRequest.index(index);
                    updateRequest.id(id);
                    updateRequest.doc(indexRequest);
                    UpdateResponse rspose = this.client.update(updateRequest, options);
                    LOGGER.info(JSONObject.toJSONString((Object)rspose));
                }
                catch (Exception ie) {
                    LOGGER.error("\u51fa\u73b0Connection reset by peer\u5f02\u5e38\u91cd\u8bd5\u4e4b\u540e\u4ecd\u7136\u5931\u8d25\uff1a" + ie.getMessage());
                    return false;
                }
            }
            LOGGER.error("es \u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage());
            throw new Exception(e.getMessage(), e);
        }
        return deleteResult;
    }

    @Override
    public Boolean updateBatchData(String index, Map<String, Map<String, Object>> maps) throws IOException {
        boolean result = true;
        BulkRequest request = new BulkRequest();
        maps.forEach((id, map) -> {
            HashMap<String, Object> processedMap = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    ArrayList<Map<String, Object>> processedList = new ArrayList<Map<String, Object>>();
                    for (Object item : collection) {
                        if (!(item == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Map || item instanceof Collection)) {
                            processedList.add(this.convertObjectToMap(item));
                            continue;
                        }
                        processedList.add((Map<String, Object>)item);
                    }
                    processedMap.put(key, processedList);
                    continue;
                }
                if (!(value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Map)) {
                    processedMap.put(key, this.convertObjectToMap(value));
                    continue;
                }
                processedMap.put(key, value);
            }
            request.add(new UpdateRequest(index, id.toString()).doc(processedMap).upsert(new Object[0]));
        });
        BulkResponse response = this.client.bulk(request, RequestOptions.DEFAULT);
        LOGGER.info(JSONObject.toJSONString((Object)response));
        if (response.hasFailures()) {
            result = false;
            LOGGER.error("\u6279\u91cf\u66f4\u65b0\u5931\u8d25: {}", (Object)response.buildFailureMessage());
        }
        return result;
    }

    private Map<String, Object> convertObjectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (Map)mapper.convertValue(obj, Map.class);
        }
        catch (Exception e) {
            LOGGER.warn("\u8f6c\u6362\u5bf9\u8c61\u4e3aMap\u5931\u8d25\uff0c\u4f7f\u7528toString: {}", (Object)obj.getClass().getName(), (Object)e);
            HashMap<String, Object> fallbackMap = new HashMap<String, Object>();
            fallbackMap.put("value", obj.toString());
            return fallbackMap;
        }
    }

    @Override
    public Boolean updateBatchDataForNull(String index, Map<String, Map<String, Object>> maps) throws IOException {
        boolean result = true;
        BulkRequest request = new BulkRequest();
        maps.forEach((id, map) -> {
            HashMap<String, Object> processedMap = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    ArrayList<Map<String, Object>> processedList = new ArrayList<Map<String, Object>>();
                    for (Object item : collection) {
                        if (!(item == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Map || item instanceof Collection)) {
                            processedList.add(this.convertObjectToMap(item));
                            continue;
                        }
                        processedList.add((Map<String, Object>)item);
                    }
                    processedMap.put(key, processedList);
                    continue;
                }
                if (!(value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Map)) {
                    processedMap.put(key, this.convertObjectToMap(value));
                    continue;
                }
                processedMap.put(key, value);
            }
            request.add(new UpdateRequest(index, id.toString()).doc(processedMap).docAsUpsert(true));
        });
        BulkResponse response = this.client.bulk(request, RequestOptions.DEFAULT);
        LOGGER.info(JSONObject.toJSONString((Object)response));
        if (response.hasFailures()) {
            result = false;
            LOGGER.error("\u6279\u91cf\u66f4\u65b0\u5931\u8d25: {}", (Object)response.buildFailureMessage());
        }
        return result;
    }

    @Override
    public Boolean deleteData(String index, String id) {
        boolean deleteResult = false;
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.index(index);
        indexRequest.id(id);
        try {
            DeleteRequest deleteRequest = new DeleteRequest();
            deleteRequest.index(index);
            deleteRequest.id(id);
            DeleteResponse rspose = this.client.delete(deleteRequest, options);
            LOGGER.info(JSONObject.toJSONString((Object)rspose));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("es \u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    @Override
    public Boolean deleteBatchData(String index, List<String> ids) {
        boolean deleteResult = false;
        try {
            BulkRequest request = new BulkRequest();
            for (String id : ids) {
                request.add(((DeleteRequest)new DeleteRequest().index(index)).id(id));
            }
            BulkResponse response = this.client.bulk(request, RequestOptions.DEFAULT);
            LOGGER.info(JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("es \u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    @Override
    public String updateByQuery(String index, String qryJson) {
        String endPoint = "/" + index + "/_update_by_query";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + qryJson);
        }
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    @Override
    public void updateByScript(String index, String id, String arrayFieldName, String idFieldName, String idValue, Map<String, Object> newParams) throws IOException {
        UpdateRequest request = new UpdateRequest(index, id);
        String scriptSource = "def fieldName = params.arrayFieldName;def idField = params.idFieldName;def idValue = params.idValue;def hasNewParams = params.hasNewParams;boolean found = false;for (int i = 0; i < ctx._source[fieldName].size(); i++) {    if (ctx._source[fieldName][i][idField] == idValue) {        if (!hasNewParams) {            ctx._source[fieldName].remove(i);        } else {            ctx._source[fieldName][i] = params.newObject;        }        found = true;        break;    }}if (!found && hasNewParams) {    ctx._source[fieldName].add(params.newObject);}";
        boolean hasNewParams = newParams != null && !newParams.isEmpty();
        HashMap<String, Object> newObject = new HashMap<String, Object>();
        newObject.put(idFieldName, idValue);
        if (hasNewParams) {
            newObject.putAll(newParams);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("arrayFieldName", arrayFieldName);
        params.put("idFieldName", idFieldName);
        params.put("idValue", idValue);
        params.put("newObject", newObject);
        params.put("hasNewParams", hasNewParams);
        request.script(new Script(ScriptType.INLINE, "painless", scriptSource, params));
        UpdateResponse response = this.client.update(request, RequestOptions.DEFAULT);
        LOGGER.info("\u66f4\u65b0\u7ed3\u679c: " + response.getResult() + ", \u64cd\u4f5c\u7c7b\u578b: " + (hasNewParams ? "\u66f4\u65b0/\u65b0\u589e" : "\u5220\u9664"));
    }

    @Override
    public String updateByScript(String index, NosqlBuilder nosqlBuilder, String arrayFieldName, String idFieldName, String idValue, Map<String, Object> newParams) throws IOException {
        String queryField = arrayFieldName + "." + idFieldName;
        if (StringUtils.isNotBlank((CharSequence)queryField) && !queryField.endsWith(".keyword") && this.isKeywordField(index, queryField)) {
            queryField = queryField + ".keyword";
        }
        SearchSourceBuilder sourceBuilder = this.buildSearchRequest(index, nosqlBuilder);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must(sourceBuilder.query()).filter((QueryBuilder)QueryBuilders.existsQuery((String)arrayFieldName));
        UpdateByQueryRequest request = new UpdateByQueryRequest(new String[]{index});
        request.setQuery((QueryBuilder)boolQuery);
        request.setBatchSize(5000);
        request.setRequestsPerSecond(Float.POSITIVE_INFINITY);
        request.setConflicts("proceed");
        request.setRefresh(false);
        String scriptSource = "def fieldName = params.arrayFieldName;def idField = params.idFieldName;def idValue = params.idValue;def hasNewParams = params.hasNewParams;boolean found = false;def arrayField = ctx._source[fieldName];if (arrayField == null) {    if (hasNewParams) {        ctx._source[fieldName] = [params.newObject];        found = true;    }} else {    for (int i = 0; i < arrayField.size(); i++) {        def item = arrayField[i];        if (item != null && item[idField] == idValue) {            if (!hasNewParams) {                arrayField.remove(i);            } else {                arrayField[i] = params.newObject;            }            found = true;            break;        }    }    if (!found && hasNewParams) {        arrayField.add(params.newObject);    }}";
        boolean hasNewParams = newParams != null && !newParams.isEmpty();
        HashMap<String, Object> newObject = new HashMap<String, Object>();
        newObject.put(idFieldName, idValue);
        if (hasNewParams) {
            newObject.putAll(newParams);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("arrayFieldName", arrayFieldName);
        params.put("idFieldName", idFieldName);
        params.put("idValue", idValue);
        params.put("newObject", newObject);
        params.put("hasNewParams", hasNewParams);
        request.setScript(new Script(ScriptType.INLINE, "painless", scriptSource, params));
        long startTime = System.currentTimeMillis();
        BulkByScrollResponse response = this.client.updateByQuery(request, RequestOptions.DEFAULT);
        long endTime = System.currentTimeMillis();
        String res = "\u66f4\u65b0\u7ed3\u679c: \u6210\u529f\u66f4\u65b0 " + response.getUpdated() + " \u4e2a\u6587\u6863, \u64cd\u4f5c\u7c7b\u578b: " + (hasNewParams ? "\u66f4\u65b0/\u65b0\u589e" : "\u5220\u9664") + ", \u8017\u65f6: " + (endTime - startTime) + "ms";
        LOGGER.info(res);
        return res;
    }

    public RestClient getLowLevelClient() {
        return this.client.getLowLevelClient();
    }

    public void setClient(RestHighLevelClient client) {
        this.client = client;
    }

    static {
        RequestOptions.Builder requestOptions = RequestOptions.DEFAULT.toBuilder();
        requestOptions.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(524288000));
        options = requestOptions.build();
        mapper = new ObjectMapper();
    }
}

