/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.nosql.config;

import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.config.EsOrNot;
import com.ohaotian.plugin.nosql.es.EsManagerImpl;
import com.ohaotian.plugin.nosql.impl.NosqlClientImpl;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;

@Configuration
public class NosqlConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(NosqlConfiguration.class);
    @Value(value="${nosql.cluster.address}")
    private String clusterNodes;
    @Value(value="${nosql.source:}")
    private String source;
    @Value(value="${nosql.client.username:}")
    private String esClientUsername;
    @Value(value="${nosql.client.password:}")
    private String esClientPassword;
    @Value(value="${nosql.pool.maxTotal:20}")
    private int maxTotal;
    @Value(value="${nosql.pool.connectionTimeout:5000}")
    private int connectionTimeout;
    @Value(value="${nosql.pool.socketTimeout:60000}")
    private int socketTimeout;
    @Value(value="${nosql.pool.connectionRequestTimeout:1000}")
    private int connectionRequestTimeout;
    @Value(value="${nosql.config.keepAlive.timeout:180}")
    private long keepAliveTimeout;
    private RestHighLevelClient restHighLevelClient;

    @Bean
    @Primary
    @Conditional(value={EsOrNot.class})
    public EsManagerImpl esManager() {
        EsManagerImpl manager = new EsManagerImpl();
        manager.setClient(this.buildEsClient());
        return manager;
    }

    @Bean
    @Primary
    public NosqlClient nosqlClient() {
        NosqlClientImpl nosqlClient = new NosqlClientImpl();
        if ("".equals(this.source) || "ES".equals(this.source)) {
            logger.info("ES\u542f\u52a8");
            nosqlClient.setNosqlManager(this.esManager());
        }
        return nosqlClient;
    }

    private RestHighLevelClient buildEsClient() {
        RestClientBuilder clientBuilder = null;
        try {
            if (StringUtils.isEmpty((Object)this.clusterNodes)) {
                return null;
            }
            ArrayList<String> ipAdrrs = new ArrayList<String>(Arrays.asList(this.clusterNodes.split(",")));
            HttpHost httpHost = null;
            HttpHost[] httpHosts = new HttpHost[ipAdrrs.size()];
            for (int i = 0; i < ipAdrrs.size(); ++i) {
                httpHosts[i] = httpHost = new HttpHost(((String)ipAdrrs.get(i)).split(":")[0], Integer.valueOf(((String)ipAdrrs.get(i)).split(":")[1]).intValue(), "http");
            }
            clientBuilder = RestClient.builder((HttpHost[])httpHosts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        clientBuilder.setFailureListener(new RestClient.FailureListener(){

            public void onFailure(HttpHost host) {
                super.onFailure(new Node(host));
                System.out.println(host.getHostName() + "==\u8282\u70b9\u5931\u8d25\u4e86");
            }
        });
        clientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                httpAsyncClientBuilder.setKeepAliveStrategy((response, context) -> NosqlConfiguration.this.keepAliveTimeout * 1000L);
                return httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(NosqlConfiguration.this.maxTotal).build());
            }
        });
        clientBuilder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                return requestConfigBuilder.setConnectTimeout(NosqlConfiguration.this.connectionTimeout).setSocketTimeout(NosqlConfiguration.this.socketTimeout).setConnectionRequestTimeout(NosqlConfiguration.this.connectionRequestTimeout);
            }
        });
        if (this.esClientPassword != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.esClientUsername, this.esClientPassword));
            clientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                final /* synthetic */ CredentialsProvider val$credentialsProvider;
                {
                    this.val$credentialsProvider = credentialsProvider;
                }

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                    return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                }
            });
        }
        this.restHighLevelClient = new RestHighLevelClient(clientBuilder);
        return this.restHighLevelClient;
    }
}

