/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.elasticsearch.builder.update;

import com.ohaotian.plugin.es.builder.insert.ColumnValueBuilder;
import com.ohaotian.plugin.es.builder.insert.InsertBuilderItem;
import com.ohaotian.plugin.es.builder.schema.DataType;
import com.ohaotian.plugin.es.builder.schema.Field;
import com.ohaotian.plugin.es.builder.schema.Nested;
import com.ohaotian.plugin.es.builder.update.UpdateRequestBuilder;
import com.ohaotian.plugin.es.elasticsearch.ElasticSearchClient;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EsUpdateRequestBuilder
implements UpdateRequestBuilder<EsUpdateBuilderItem> {
    private final Logger logger = LogManager.getLogger(EsUpdateRequestBuilder.class);
    @Autowired
    private ElasticSearchClient client;

    @Override
    public EsUpdateBuilderItem build(String tableName, String id, ColumnValueBuilder columnValueBuilder) {
        IndexRequestBuilder indexRequestBuilder = this.client.indexRequestBuilder();
        indexRequestBuilder.setIndex(tableName);
        indexRequestBuilder.setType("default");
        indexRequestBuilder.setId(id);
        indexRequestBuilder.setOpType(DocWriteRequest.OpType.INDEX);
        LinkedHashMap<String, Object> source = new LinkedHashMap<String, Object>();
        Object fields = columnValueBuilder.build();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (DataType.Double.equals((Object)field.getDateType()) || DataType.Integer.equals((Object)field.getDateType()) || DataType.Long.equals((Object)field.getDateType())) {
                source.put(field.getName(), field.getValue());
                continue;
            }
            if (DataType.Text.equals((Object)field.getDateType())) {
                source.put(field.getName(), field.getValue());
                continue;
            }
            if (!DataType.Nested.equals((Object)field.getDateType())) continue;
            Nested nested = (Nested)field.getValue();
            LinkedList nestedList = new LinkedList();
            for (String nestedRow : nested.getRows()) {
                LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
                valueMap.put("nested_id", nestedRow);
                nestedList.add(valueMap);
            }
            source.put(field.getName(), nestedList);
        }
        indexRequestBuilder.setSource(source);
        this.logger.debug("insert source: {}", source);
        return new EsUpdateBuilderItem(indexRequestBuilder);
    }

    public class EsUpdateBuilderItem
    implements InsertBuilderItem {
        private final IndexRequestBuilder indexRequestBuilder;

        public EsUpdateBuilderItem(IndexRequestBuilder indexRequestBuilder) {
            this.indexRequestBuilder = indexRequestBuilder;
        }

        @Override
        public String get() {
            return String.valueOf(((IndexResponse)this.indexRequestBuilder.get()).getResult());
        }
    }
}

