/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.annotation;

import com.ohaotian.plugin.es.annotation.DaoAdapterFactory;
import com.ohaotian.plugin.es.annotation.DaoAutowiredBeanContainer;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DaoInjector {
    private final Logger logger = LogManager.getLogger(DaoInjector.class);
    @Autowired
    private DaoAutowiredBeanContainer container;

    public void inject(DBType dbType) {
        for (DaoAutowiredBeanContainer.DaoAutowiredBean autowiredBean : this.container.getBeans()) {
            Object bean = autowiredBean.getBean();
            Field field = autowiredBean.getDaoField();
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            String interfaceName = field.getType().getName();
            Object value = ((DaoAdapterFactory)this.container.getFactoryMap().get(interfaceName)).generate(field.getType(), dbType);
            try {
                if (value == null) continue;
                field.set(bean, value);
            }
            catch (Throwable e) {
                this.logger.error("DAO\u81ea\u52a8\u88c5\u8f7d\u5931\u8d25\uff0c\u5c5e\u6027\u540d:", (Object)(field.getName() + ",\u6240\u5c5e\u7c7b\u540d:" + bean.getClass().getName() + ", \u9519\u8bef\u4fe1\u606f: " + e.getMessage()), (Object)e);
            }
        }
    }

    public static enum DBType {
        ElasticSearch,
        OpenSearch;

    }
}

