/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.elasticsearch.builder.search;

import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.ohaotian.plugin.es.builder.search.AggregateBuilder;
import com.ohaotian.plugin.es.builder.search.FetchBuilder;
import com.ohaotian.plugin.es.builder.search.FilterBuilder;
import com.ohaotian.plugin.es.builder.search.QueryBuilder;
import com.ohaotian.plugin.es.builder.search.RankBuilder;
import com.ohaotian.plugin.es.builder.search.SearchRequestBuilder;
import com.ohaotian.plugin.es.builder.search.SortBuilder;
import com.ohaotian.plugin.es.builder.search.query.QueryCondition;
import com.ohaotian.plugin.es.builder.search.result.Result;
import com.ohaotian.plugin.es.builder.search.sort.SearchSortMode;
import com.ohaotian.plugin.es.builder.search.sort.SortColumn;
import com.ohaotian.plugin.es.elasticsearch.ElasticSearchClient;
import com.ohaotian.plugin.es.elasticsearch.builder.search.ElasticSearchFilterBuilder;
import com.ohaotian.plugin.es.elasticsearch.builder.search.ElasticSearchQueryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.nested.NestedBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EsSearchRequestBuilder
implements SearchRequestBuilder {
    private final Logger logger = LogManager.getLogger(EsSearchRequestBuilder.class);
    @Autowired
    private ElasticSearchClient client;

    @Override
    public Result build(String indexName, int from, int size, QueryBuilder queryBuilder, FilterBuilder filterBuilder, FetchBuilder fetchBuilder, SortBuilder sortBuilder, AggregateBuilder aggregateBuilder, RankBuilder rankBuilder, String kvpairs) {
        Object column;
        Object condition;
        org.elasticsearch.action.search.SearchRequestBuilder searchRequestBuilder = this.client.searchRequestBuilder();
        searchRequestBuilder.setIndices(new String[]{indexName});
        searchRequestBuilder.setTypes(new String[]{"default"});
        searchRequestBuilder.setFrom(from);
        if (size > 0) {
            searchRequestBuilder.setSize(size);
        }
        if (fetchBuilder != null) {
            String[] includes = new String[fetchBuilder.build().size()];
            searchRequestBuilder.setFetchSource(fetchBuilder.build().toArray(includes), null);
        }
        if (queryBuilder != null) {
            condition = queryBuilder.build();
            searchRequestBuilder.setQuery(ElasticSearchQueryBuilder.INSTANCE.build((QueryCondition)condition));
        }
        if (filterBuilder != null) {
            searchRequestBuilder.setPostFilter(ElasticSearchFilterBuilder.INSTANCE.build(filterBuilder.build()));
        }
        if (sortBuilder != null) {
            condition = sortBuilder.build().iterator();
            while (condition.hasNext()) {
                column = (SortColumn)condition.next();
                if (SearchSortMode.ASC.equals((Object)((SortColumn)column).getMode())) {
                    searchRequestBuilder.addSort((org.elasticsearch.search.sort.SortBuilder)SortBuilders.fieldSort((String)((SortColumn)column).getName()).order(SortOrder.ASC));
                    continue;
                }
                if (!SearchSortMode.DESC.equals((Object)((SortColumn)column).getMode())) continue;
                searchRequestBuilder.addSort((org.elasticsearch.search.sort.SortBuilder)SortBuilders.fieldSort((String)((SortColumn)column).getName()).order(SortOrder.DESC));
            }
        }
        if (aggregateBuilder != null) {
            Object aggColumns = aggregateBuilder.build();
            column = aggColumns.iterator();
            while (column.hasNext()) {
                AggregateBuilder.AggregateColumn aggColumn = (AggregateBuilder.AggregateColumn)column.next();
                if (aggColumn.isNested()) {
                    NestedBuilder nestedAggregationBuilder = AggregationBuilders.nested((String)"nested_option").path(aggColumn.getName());
                    nestedAggregationBuilder.subAggregation((AbstractAggregationBuilder)AggregationBuilders.terms((String)"group_nested_id").field(aggColumn.getName() + "." + "nested_id"));
                    searchRequestBuilder.addAggregation((AbstractAggregationBuilder)nestedAggregationBuilder);
                    continue;
                }
                searchRequestBuilder.addAggregation((AbstractAggregationBuilder)AggregationBuilders.terms((String)aggColumn.getName()));
            }
        }
        this.logger.debug("search request: {}", (Object)searchRequestBuilder);
        SearchResponse response = (SearchResponse)searchRequestBuilder.get();
        String resultJsonStr = response.toString();
        this.logger.debug("search result: {}", (Object)resultJsonStr);
        JSONObject resultJson = new JSONObject(resultJsonStr);
        Result result = new Result();
        result.setStatus(true);
        JSONObject responseResult = resultJson.getJSONObject("hits");
        result.setTotal(responseResult.getLong("total"));
        result.setItems(responseResult.getJSONArray("hits"));
        if (responseResult.has("aggregations")) {
            result.setAggs(responseResult.getJSONArray("aggregations"));
        }
        return result;
    }
}

