package com.ohaotian.plugin.es.annotation;

import com.ohaotian.plugin.es.elasticsearch.ElasticSearchDAO;
import com.ohaotian.plugin.es.opensearch.OpenSearchDAO;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class BeanPostProcessorListener implements BeanPostProcessor {

    private final Logger logger = LogManager.getLogger(BeanPostProcessorListener.class);

    @Autowired
    private DaoAutowiredBeanContainer beanContainer;

    @Override public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Field[] fields = bean.getClass().getDeclaredFields();
        for (Field field : fields) {
            DaoAutowired daoAutowired = field.getAnnotation(DaoAutowired.class);
            if (daoAutowired != null) {
                beanContainer.addDaoAutowiredBean(new DaoAutowiredBeanContainer.DaoAutowiredBean(bean, field));
                logger.debug("发现包含DaoAutowired属性注解的类：{}, 属性名: {}", bean.getClass().getName(), field.getName());
            }
        }
        return bean;
    }

    @Override public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ElasticSearchDAO) {
            for (Class<?> beanClass : bean.getClass().getInterfaces()) {
                logger.debug("发现实现了ElasticSearchDAO接口的DAO装载完成，将其添加到Container中,接口名: {}", beanClass.getName());
                beanContainer.getOrCreate(beanClass.getName()).setEsDao((ElasticSearchDAO)bean);
            }
        }else if (bean instanceof OpenSearchDAO) {
            for (Class<?> beanClass : bean.getClass().getInterfaces()) {
                logger.debug("发现实现了OpenSearchDAO接口的DAO装载完成，将其添加到Container中,接口名: {}", beanClass.getName());
                beanContainer.getOrCreate(beanClass.getName()).setOsDao((OpenSearchDAO)bean);
            }
        }
        return bean;
    }
}
