package com.ohaotian.plugin.es.builder.batch;

import com.ohaotian.plugin.es.annotation.DaoInjector;
import com.ohaotian.plugin.es.builder.Adapter;
import com.ohaotian.plugin.es.opensearch.builder.batch.OsBatchUpdateRequestBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/** <br>
 * 标题: <br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho yudg
 * @time 2017年9月22日 下午11:02:01 */
@Component
public class BatchUpdateRequestBuilderAdapter implements Adapter<BatchUpdateRequestBuilder> {

	private DaoInjector.DBType			dbType;

	@Autowired
	private OsBatchUpdateRequestBuilder	osBatchUpdateRequestBuilder;

	// @Autowired
	// private EsBatchDeleteRequestBuilder esBatchDeleteRequestBuilder;

	@Override
	public void setDBType(DaoInjector.DBType dbType) {
		this.dbType = dbType;
	}

	@Override
	public BatchUpdateRequestBuilder requestBuilder() {
		// if (DaoInjector.DBType.ElasticSearch.equals(dbType)) {
		// return esBatchDeleteRequestBuilder;
		// }
		// else
		if (DaoInjector.DBType.OpenSearch.equals(dbType)) {
			return osBatchUpdateRequestBuilder;
		}
		else {
			throw new RuntimeException("启动的数据库类型未找到，请检查数据库配置");
		}
	}
}
