package com.ohaotian.plugin.es.elasticsearch;

import com.ohaotian.plugin.es.core.ConfigCheck;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * @author pengys5
 */
@Component
public class ElasticSearchConfigCheck implements ConfigCheck {

    private final Logger logger = LogManager.getLogger(ElasticSearchConfigCheck.class);

    @Autowired
    private ElasticSearchConfig config;

    @Override public boolean check() {
        logger.info("elastic search config, cluster name: {}", config.getClusterName());
        logger.info("elastic search config, cluster nodes: {}", config.getClusterNodes());

        Boolean isOk = false;
        if (!StringUtils.isEmpty(config.getClusterName()) && !StringUtils.isEmpty(config.getClusterNodes())) {
            isOk = true;
        }
        return isOk;
    }
}
