package com.ohaotian.plugin.es.elasticsearch.builder.delete;

import com.ohaotian.plugin.es.Const;
import com.ohaotian.plugin.es.builder.delete.DeleteBuilderItem;
import com.ohaotian.plugin.es.builder.delete.DeleteRequestBuilder;
import com.ohaotian.plugin.es.builder.insert.ColumnValueBuilder;
import com.ohaotian.plugin.es.builder.schema.DataType;
import com.ohaotian.plugin.es.builder.schema.Field;
import com.ohaotian.plugin.es.builder.schema.Nested;
import com.ohaotian.plugin.es.elasticsearch.ElasticSearchClient;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class EsDeleteRequestBuilder implements DeleteRequestBuilder<EsDeleteRequestBuilder.EsDeleteBuilderItem> {

    private final Logger logger = LogManager.getLogger(EsDeleteRequestBuilder.class);

    @Autowired
    private ElasticSearchClient client;
    @Override
	public EsDeleteBuilderItem build(String tableName, String id, ColumnValueBuilder columnValueBuilder) {
    	 IndexRequestBuilder indexRequestBuilder = this.client.indexRequestBuilder();
         indexRequestBuilder.setIndex(tableName);
         indexRequestBuilder.setType(Const.ELASTIC_SEARCH_TYPE);
         indexRequestBuilder.setId(id);
         indexRequestBuilder.setOpType(IndexRequest.OpType.INDEX);

         Map<String, Object> source = new LinkedHashMap<>();

         List<Field> fields = columnValueBuilder.build();
         for (Field field : fields) {
             if (DataType.Double.equals(field.getDateType()) || DataType.Integer.equals(field.getDateType()) || DataType.Long.equals(field.getDateType())) {
                 source.put(field.getName(), field.getValue());
             } else if (DataType.Text.equals(field.getDateType())) {
                 source.put(field.getName(), field.getValue());
             } else if (DataType.Nested.equals(field.getDateType())) {
                 Nested nested = (Nested)field.getValue();

                 List<Map<String, String>> nestedList = new LinkedList<>();
                 for (String nestedRow : nested.getRows()) {
                     Map<String, String> valueMap = new LinkedHashMap<>();
                     valueMap.put(Const.ELASTIC_NESTED_ID, nestedRow);
                     nestedList.add(valueMap);
                 }
                 source.put(field.getName(), nestedList);
             }
         }

         indexRequestBuilder.setSource(source);
         logger.debug("delete source: {}", source);

         return new EsDeleteBuilderItem(indexRequestBuilder);
	}
    
    public class EsDeleteBuilderItem implements DeleteBuilderItem {
        private final IndexRequestBuilder indexRequestBuilder;

        public EsDeleteBuilderItem(IndexRequestBuilder indexRequestBuilder) {
            this.indexRequestBuilder = indexRequestBuilder;
        }

        @Override public String get() {
            return String.valueOf(indexRequestBuilder.get().getResult());
        }
    }
}
