package com.ohaotian.plugin.es.opensearch.builder.update;

import com.aliyun.opensearch.DocumentClient;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import com.aliyun.opensearch.sdk.generated.document.Command;
import com.aliyun.opensearch.sdk.generated.document.DocumentConstants;
import com.ohaotian.plugin.es.builder.insert.ColumnValueBuilder;
import com.ohaotian.plugin.es.builder.schema.DataType;
import com.ohaotian.plugin.es.builder.schema.Field;
import com.ohaotian.plugin.es.builder.schema.Nested;
import com.ohaotian.plugin.es.builder.update.UpdateBuilderItem;
import com.ohaotian.plugin.es.builder.update.UpdateRequestBuilder;
import com.ohaotian.plugin.es.opensearch.OpenSearchClient;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
/**
 * 
 * <br>
 * 标题: <br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * @autho yudg
 * @time 2017年9月22日 下午10:55:56
 */
@Component
public class OsUpdateRequestBuilder implements UpdateRequestBuilder<OsUpdateRequestBuilder.OsUpdateBuilderItem> {

    private final Logger logger = LogManager.getLogger(OsUpdateRequestBuilder.class);

    @Autowired
    private OpenSearchClient client;

    @Override public OsUpdateBuilderItem build(String tableName, String id, ColumnValueBuilder columnValueBuilder) {
        JSONArray rows = new JSONArray();
        JSONObject row = new JSONObject();
        row.put(DocumentConstants.DOC_KEY_CMD, Command.UPDATE.toString());
        rows.put(row);

        JSONObject doc = new JSONObject();
        row.put(DocumentConstants.DOC_KEY_FIELDS, doc);

        List<Field> fields = columnValueBuilder.build();
        for (Field field : fields) {
            if (DataType.Double.equals(field.getDateType()) || DataType.Integer.equals(field.getDateType()) || DataType.Long.equals(field.getDateType())) {
                doc.put(field.getName(), field.getValue());
            } else if (DataType.Text.equals(field.getDateType())) {
                doc.put(field.getName(), field.getValue());
            } else if (DataType.Nested.equals(field.getDateType())) {
                Nested nested = (Nested)field.getValue();
                JSONArray nestedArray = new JSONArray();
                for (String nestedRow : nested.getRows()) {
                    nestedArray.put(nestedRow);
                }
                doc.put(field.getName(), nestedArray);
            }
        }

        return new OsUpdateBuilderItem(tableName, rows, client);
    }

    public class OsUpdateBuilderItem implements UpdateBuilderItem {
        private final String tableName;
        private final JSONArray rows;
        private final OpenSearchClient client;

        public OsUpdateBuilderItem(String tableName, JSONArray rows, OpenSearchClient client) {
            this.tableName = tableName;
            this.rows = rows;
            this.client = client;
        }

        public String get() {
            try {
                DocumentClient documentClient = this.client.createDocumentClient();
                OpenSearchResult result = documentClient.push(rows.toString(), tableName, tableName);
                return result.getResult();
            } catch (OpenSearchException | OpenSearchClientException e) {
                logger.error(e.getMessage(), e);
            }
            return null;
        }

        public String getTableName() {
            return tableName;
        }

        public JSONArray getRows() {
            return rows;
        }
    }
}
