package com.ohaotian.plugin.es;

import com.ohaotian.plugin.es.core.ClientException;
import com.ohaotian.plugin.es.core.Installer;
import com.ohaotian.plugin.es.elasticsearch.ElasticSearchInstaller;
import com.ohaotian.plugin.es.opensearch.OpenSearchInstaller;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class SearchModuleInstaller implements Installer {

    private final Logger logger = LogManager.getLogger(SearchModuleInstaller.class);

    @Autowired
    private ElasticSearchInstaller esInstaller;

    @Autowired
    private OpenSearchInstaller osInstaller;

    private boolean esIsOk = false;
    private boolean osIsOK = false;

    @Override public boolean preInstall() {
        esIsOk = esInstaller.preInstall();
        osIsOK = osInstaller.preInstall();
        return true;
    }

    @PostConstruct
    public void install() throws ClientException {
        logger.info("搜索模块开始启动装载...");
        preInstall();

        if (esIsOk && osIsOK) {
            logger.warn("检查发现同时配置了elastic search和open search，默认以elastic search进行启动.");
            esInstaller.install();
        } else if (esIsOk) {
            logger.info("elastic search配置检查无误，使用elastic search进行启动.");
            esInstaller.install();
        } else if (osIsOK) {
            logger.info("open search配置检查无误，使用open search进行启动.");
            osInstaller.install();
        } else {
            throw new RuntimeException("请配置elastic search或者open search的连接信息.");
        }
    }
}
