package com.ohaotian.plugin.es.annotation;

import com.ohaotian.plugin.es.elasticsearch.ElasticSearchDAO;
import com.ohaotian.plugin.es.opensearch.OpenSearchDAO;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

/**
 * @author pengys5
 */
public class DaoAdapterFactory implements MethodInterceptor {

    private final Logger logger = LogManager.getLogger(DaoAdapterFactory.class);

    private ElasticSearchDAO esDao;
    private OpenSearchDAO osDao;
    private DaoInjector.DBType dbType;

    public Object generate(Class interfaceClass, DaoInjector.DBType dbType) {
        logger.debug("生成接口的动态代理, 接口名：{}，要求代理的数据库类型为：{}", interfaceClass.getName(), dbType.name());
        this.dbType = dbType;

        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(interfaceClass);
        enhancer.setCallback(this);
        return enhancer.create();
    }

    @Override public Object intercept(Object o, Method method, Object[] objects, MethodProxy proxy) throws Throwable {
        if (DaoInjector.DBType.ElasticSearch.equals(dbType)) {
            return method.invoke(esDao, objects);
        }else if (DaoInjector.DBType.OpenSearch.equals(dbType)) {
            return method.invoke(osDao, objects);
        } else {
            throw new RuntimeException();
        }
    }

    public void setEsDao(ElasticSearchDAO esDao) {
        this.esDao = esDao;
    }

    public void setOsDao(OpenSearchDAO osDao) {
        this.osDao = osDao;
    }
}
